<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* emails/password-reset.html.twig */
class __TwigTemplate_ffe5630003f7b54eff0ca3471af6007b extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "emails/password-reset.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "emails/password-reset.html.twig"));

        // line 1
        yield "<!DOCTYPE html>
<html>
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <style>
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
        }
        .container {
            max-width: 600px;
            margin: 40px auto;
            background: linear-gradient(135deg, #1a0a0f 0%, #2A0713 100%);
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 20px rgba(0,0,0,0.15);
        }
        .header {
            background: rgba(201, 182, 153, 0.1);
            padding: 40px 30px;
            text-align: center;
            border-bottom: 1px solid rgba(123, 95, 81, 0.3);
        }
        .header h1 {
            color: #C9B699;
            font-family: 'Bodoni Moda', serif;
            font-size: 28px;
            margin: 0 0 10px 0;
            letter-spacing: 0.15em;
            text-transform: uppercase;
        }
        .header p {
            color: rgba(201, 182, 153, 0.7);
            font-size: 12px;
            margin: 0;
            letter-spacing: 0.1em;
            text-transform: uppercase;
        }
        .content {
            padding: 40px 30px;
            color: #C9B699;
        }
        .content p {
            margin: 0 0 20px 0;
            line-height: 1.8;
        }
        .button-container {
            text-align: center;
            margin: 30px 0;
        }
        .button {
            display: inline-block;
            padding: 16px 40px;
            background: #B6A37F;
            color: #2A0713;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            letter-spacing: 0.1em;
            text-transform: uppercase;
            font-size: 14px;
        }
        .button:hover {
            background: #C8B588;
        }
        .footer {
            padding: 30px;
            text-align: center;
            border-top: 1px solid rgba(123, 95, 81, 0.3);
            color: rgba(201, 182, 153, 0.5);
            font-size: 12px;
        }
        .warning-box {
            background: rgba(232, 203, 181, 0.1);
            border: 1px solid #E8CBB5;
            border-radius: 6px;
            padding: 15px;
            margin: 20px 0;
            color: #E8CBB5;
            font-size: 13px;
        }
        .link-text {
            color: #B6A37F;
            word-break: break-all;
            font-size: 12px;
            margin-top: 15px;
        }
    </style>
</head>
<body>
    <div class=\"container\">
        <div class=\"header\">
            <h1>Password Reset</h1>
            <p>";
        // line 99
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["systemName"]) || array_key_exists("systemName", $context) ? $context["systemName"] : (function () { throw new RuntimeError('Variable "systemName" does not exist.', 99, $this->source); })()), "html", null, true);
        yield "</p>
        </div>
        
        <div class=\"content\">
            <p>Hello,</p>
            
            <p>We received a request to reset your password for your ";
        // line 105
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["systemName"]) || array_key_exists("systemName", $context) ? $context["systemName"] : (function () { throw new RuntimeError('Variable "systemName" does not exist.', 105, $this->source); })()), "html", null, true);
        yield " account. If you made this request, click the button below to set a new password:</p>
            
            <div class=\"button-container\">
                <a href=\"";
        // line 108
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["resetUrl"]) || array_key_exists("resetUrl", $context) ? $context["resetUrl"] : (function () { throw new RuntimeError('Variable "resetUrl" does not exist.', 108, $this->source); })()), "html", null, true);
        yield "\" class=\"button\">Reset Password</a>
            </div>
            
            <p class=\"link-text\">Or copy and paste this link into your browser:<br>
                ";
        // line 112
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["resetUrl"]) || array_key_exists("resetUrl", $context) ? $context["resetUrl"] : (function () { throw new RuntimeError('Variable "resetUrl" does not exist.', 112, $this->source); })()), "html", null, true);
        yield "
            </p>
            
            <div class=\"warning-box\">
                <strong>⚠ Security Notice:</strong><br>
                This password reset link will expire in 1 hour for security reasons. If you didn't request a password reset, you can safely ignore this email.
            </div>
            
            <p style=\"margin-top: 30px;\">If you have any questions or need assistance, please contact support.</p>
            
            <p style=\"margin-top: 30px; color: rgba(201, 182, 153, 0.7);\">
                Best regards,<br>
                The ";
        // line 124
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["systemName"]) || array_key_exists("systemName", $context) ? $context["systemName"] : (function () { throw new RuntimeError('Variable "systemName" does not exist.', 124, $this->source); })()), "html", null, true);
        yield " Team
            </p>
        </div>
        
        <div class=\"footer\">
            <p>This is an automated email. Please do not reply to this message.</p>
            <p style=\"margin-top: 10px;\">© ";
        // line 130
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate("now", "Y"), "html", null, true);
        yield " ";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["systemName"]) || array_key_exists("systemName", $context) ? $context["systemName"] : (function () { throw new RuntimeError('Variable "systemName" does not exist.', 130, $this->source); })()), "html", null, true);
        yield ". All rights reserved.</p>
        </div>
    </div>
</body>
</html>
";
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "emails/password-reset.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  194 => 130,  185 => 124,  170 => 112,  163 => 108,  157 => 105,  148 => 99,  48 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("<!DOCTYPE html>
<html>
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <style>
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
        }
        .container {
            max-width: 600px;
            margin: 40px auto;
            background: linear-gradient(135deg, #1a0a0f 0%, #2A0713 100%);
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 20px rgba(0,0,0,0.15);
        }
        .header {
            background: rgba(201, 182, 153, 0.1);
            padding: 40px 30px;
            text-align: center;
            border-bottom: 1px solid rgba(123, 95, 81, 0.3);
        }
        .header h1 {
            color: #C9B699;
            font-family: 'Bodoni Moda', serif;
            font-size: 28px;
            margin: 0 0 10px 0;
            letter-spacing: 0.15em;
            text-transform: uppercase;
        }
        .header p {
            color: rgba(201, 182, 153, 0.7);
            font-size: 12px;
            margin: 0;
            letter-spacing: 0.1em;
            text-transform: uppercase;
        }
        .content {
            padding: 40px 30px;
            color: #C9B699;
        }
        .content p {
            margin: 0 0 20px 0;
            line-height: 1.8;
        }
        .button-container {
            text-align: center;
            margin: 30px 0;
        }
        .button {
            display: inline-block;
            padding: 16px 40px;
            background: #B6A37F;
            color: #2A0713;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            letter-spacing: 0.1em;
            text-transform: uppercase;
            font-size: 14px;
        }
        .button:hover {
            background: #C8B588;
        }
        .footer {
            padding: 30px;
            text-align: center;
            border-top: 1px solid rgba(123, 95, 81, 0.3);
            color: rgba(201, 182, 153, 0.5);
            font-size: 12px;
        }
        .warning-box {
            background: rgba(232, 203, 181, 0.1);
            border: 1px solid #E8CBB5;
            border-radius: 6px;
            padding: 15px;
            margin: 20px 0;
            color: #E8CBB5;
            font-size: 13px;
        }
        .link-text {
            color: #B6A37F;
            word-break: break-all;
            font-size: 12px;
            margin-top: 15px;
        }
    </style>
</head>
<body>
    <div class=\"container\">
        <div class=\"header\">
            <h1>Password Reset</h1>
            <p>{{ systemName }}</p>
        </div>
        
        <div class=\"content\">
            <p>Hello,</p>
            
            <p>We received a request to reset your password for your {{ systemName }} account. If you made this request, click the button below to set a new password:</p>
            
            <div class=\"button-container\">
                <a href=\"{{ resetUrl }}\" class=\"button\">Reset Password</a>
            </div>
            
            <p class=\"link-text\">Or copy and paste this link into your browser:<br>
                {{ resetUrl }}
            </p>
            
            <div class=\"warning-box\">
                <strong>⚠ Security Notice:</strong><br>
                This password reset link will expire in 1 hour for security reasons. If you didn't request a password reset, you can safely ignore this email.
            </div>
            
            <p style=\"margin-top: 30px;\">If you have any questions or need assistance, please contact support.</p>
            
            <p style=\"margin-top: 30px; color: rgba(201, 182, 153, 0.7);\">
                Best regards,<br>
                The {{ systemName }} Team
            </p>
        </div>
        
        <div class=\"footer\">
            <p>This is an automated email. Please do not reply to this message.</p>
            <p style=\"margin-top: 10px;\">© {{ \"now\"|date(\"Y\") }} {{ systemName }}. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
", "emails/password-reset.html.twig", "E:\\websites\\webberdoo\\1.2025\\boilerplate\\templates\\emails\\password-reset.html.twig");
    }
}
