<?php

namespace App\Service;

class QrService
{
    /**
     * Generate a simple QR code URL using an external service
     * In production, you could use a PHP library like endroid/qr-code
     */
    public function generateQrCodeUrl(string $data, int $size = 300): string
    {
        return 'https://api.qrserver.com/v1/create-qr-code/?size=' . $size . 'x' . $size . '&data=' . urlencode($data);
    }

    public function generateHouseholdQrData(int $householdId, int $eventId, string $baseUrl): string
    {
        return $baseUrl . '/q/' . $householdId . '-' . $eventId;
    }

    public function generateGuestQrData(int $guestId, int $eventId, string $baseUrl): string
    {
        return $baseUrl . '/q/g/' . $guestId . '-' . $eventId;
    }
}
