<?php

namespace App\Service;

use App\Entity\Event;

class IcsService
{
    public function generateIcs(Event $event): string
    {
        $now = new \DateTime();
        $dtStamp = $now->format('Ymd\THis\Z');
        
        $uid = uniqid('event-') . '@wedding';
        $summary = $event->getName();
        $location = $event->getVenueName() ?? '';
        
        if ($event->getVenueAddress()) {
            $location .= ', ' . str_replace(["\r\n", "\n", "\r"], ', ', $event->getVenueAddress());
        }

        $dtStart = $event->getStartAt() ? $event->getStartAt()->format('Ymd\THis') : '';
        $dtEnd = $event->getEndAt() ? $event->getEndAt()->format('Ymd\THis') : '';

        $ics = "BEGIN:VCALENDAR\r\n";
        $ics .= "VERSION:2.0\r\n";
        $ics .= "PRODID:-//Wedding RSVP//EN\r\n";
        $ics .= "BEGIN:VEVENT\r\n";
        $ics .= "UID:$uid\r\n";
        $ics .= "DTSTAMP:$dtStamp\r\n";
        $ics .= "DTSTART:$dtStart\r\n";
        if ($dtEnd) {
            $ics .= "DTEND:$dtEnd\r\n";
        }
        $ics .= "SUMMARY:$summary\r\n";
        if ($location) {
            $ics .= "LOCATION:$location\r\n";
        }
        $ics .= "END:VEVENT\r\n";
        $ics .= "END:VCALENDAR\r\n";

        return $ics;
    }
}
