<?php

namespace App\Repository;

use App\Entity\Rsvp;
use App\Entity\Guest;
use App\Entity\Event;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

class RsvpRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Rsvp::class);
    }

    public function findByGuestAndEvent(Guest $guest, Event $event): ?Rsvp
    {
        return $this->findOneBy(['guest' => $guest, 'event' => $event]);
    }
}
