<?php

namespace App\Repository;

use App\Entity\HouseholdEventRsvp;
use App\Entity\Household;
use App\Entity\Event;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

class HouseholdEventRsvpRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, HouseholdEventRsvp::class);
    }

    public function findByHouseholdAndEvent(Household $household, Event $event): ?HouseholdEventRsvp
    {
        return $this->findOneBy(['household' => $household, 'event' => $event]);
    }
}
