<?php

namespace App\Entity;

use App\Repository\ThemeSettingRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ThemeSettingRepository::class)]
class ThemeSetting
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 50)]
    private ?string $name = null;

    #[ORM\Column(length: 50)]
    private ?string $primaryColor = null;

    #[ORM\Column(length: 50)]
    private ?string $accent = null;

    #[ORM\Column(length: 50)]
    private ?string $bg = null;

    #[ORM\Column(length: 50)]
    private ?string $text = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $fontHeading = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $fontBody = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $fieldBorder = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $accentHover = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $error = null;

    #[ORM\Column(type: 'boolean')]
    private bool $isActive = false;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;
        return $this;
    }

    public function getPrimaryColor(): ?string
    {
        return $this->primaryColor;
    }

    public function setPrimaryColor(string $primaryColor): static
    {
        $this->primaryColor = $primaryColor;
        return $this;
    }

    public function getAccent(): ?string
    {
        return $this->accent;
    }

    public function setAccent(string $accent): static
    {
        $this->accent = $accent;
        return $this;
    }

    public function getBg(): ?string
    {
        return $this->bg;
    }

    public function setBg(string $bg): static
    {
        $this->bg = $bg;
        return $this;
    }

    public function getText(): ?string
    {
        return $this->text;
    }

    public function setText(string $text): static
    {
        $this->text = $text;
        return $this;
    }

    public function getFontHeading(): ?string
    {
        return $this->fontHeading;
    }

    public function setFontHeading(?string $fontHeading): static
    {
        $this->fontHeading = $fontHeading;
        return $this;
    }

    public function getFontBody(): ?string
    {
        return $this->fontBody;
    }

    public function setFontBody(?string $fontBody): static
    {
        $this->fontBody = $fontBody;
        return $this;
    }

    public function getFieldBorder(): ?string
    {
        return $this->fieldBorder;
    }

    public function setFieldBorder(?string $fieldBorder): static
    {
        $this->fieldBorder = $fieldBorder;
        return $this;
    }

    public function getAccentHover(): ?string
    {
        return $this->accentHover;
    }

    public function setAccentHover(?string $accentHover): static
    {
        $this->accentHover = $accentHover;
        return $this;
    }

    public function getError(): ?string
    {
        return $this->error;
    }

    public function setError(?string $error): static
    {
        $this->error = $error;
        return $this;
    }

    public function isActive(): bool
    {
        return $this->isActive;
    }

    public function setIsActive(bool $isActive): static
    {
        $this->isActive = $isActive;
        return $this;
    }
}
