<?php

namespace App\Entity;

use App\Repository\SettingRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: SettingRepository::class)]
class Setting
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 50)]
    private string $publicRsvpMode = 'HOUSEHOLD';

    #[ORM\Column(length: 255)]
    private ?string $coupleNames = null;

    #[ORM\Column(type: Types::DATE_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $weddingDate = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $locationText = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $rsvpDeadline = null;

    #[ORM\Column(length: 4)]
    private ?string $staffPin = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $baseUrl = null;

    #[ORM\Column(length: 10)]
    private string $localeDefault = 'en';

    #[ORM\Column(type: Types::SMALLINT)]
    private int $maxPlusOnesPerHousehold = 2;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $smtpHost = null;

    #[ORM\Column(nullable: true)]
    private ?int $smtpPort = 587;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $smtpUsername = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $smtpPassword = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $smtpEncryption = 'tls';

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $emailFromAddress = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $emailFromName = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $inviteEmailSubject = "You're Invited to Our Wedding!";

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $inviteEmailBody = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $reminderEmailSubject = "Reminder: Please RSVP to Our Wedding";

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $reminderEmailBody = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $emailButtonText = 'RSVP Now';

    #[ORM\Column(length: 20, nullable: true)]
    private ?string $emailButtonColor = '#c2185b';

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $emailCallToAction = 'Please RSVP by clicking the button below:';

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $emailClosingText = "We can't wait to celebrate with you!";

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $emailSignature = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $ticketEmailSubject = "Your QR Code Ticket for {eventName}";

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $ticketEmailBody = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $ticketEmailGreeting = "Dear {guestName},";

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $ticketEmailIntro = "<p>Thank you for confirming your attendance! We're so excited to celebrate with you.</p>";

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $ticketEmailButtonText = "View My Ticket";

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $ticketEmailInstructions = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $ticketEmailClosing = "We can't wait to see you there!";

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $ticketEmailFooter = "<p>This is your personal QR code ticket. Please do not share this link.</p><p style=\"color: #999; font-size: 12px; margin-top: 10px;\">Lost your ticket? Contact us and we'll resend it.</p>";

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPublicRsvpMode(): string
    {
        return $this->publicRsvpMode;
    }

    public function setPublicRsvpMode(string $publicRsvpMode): static
    {
        $this->publicRsvpMode = $publicRsvpMode;
        return $this;
    }

    public function getCoupleNames(): ?string
    {
        return $this->coupleNames;
    }

    public function setCoupleNames(?string $coupleNames): static
    {
        $this->coupleNames = $coupleNames;
        return $this;
    }

    public function getWeddingDate(): ?\DateTimeInterface
    {
        return $this->weddingDate;
    }

    public function setWeddingDate(?\DateTimeInterface $weddingDate): static
    {
        $this->weddingDate = $weddingDate;
        return $this;
    }

    public function getLocationText(): ?string
    {
        return $this->locationText;
    }

    public function setLocationText(?string $locationText): static
    {
        $this->locationText = $locationText;
        return $this;
    }

    public function getRsvpDeadline(): ?\DateTimeInterface
    {
        return $this->rsvpDeadline;
    }

    public function setRsvpDeadline(?\DateTimeInterface $rsvpDeadline): static
    {
        $this->rsvpDeadline = $rsvpDeadline;
        return $this;
    }

    public function getStaffPin(): ?string
    {
        return $this->staffPin;
    }

    public function setStaffPin(?string $staffPin): static
    {
        $this->staffPin = $staffPin;
        return $this;
    }

    public function getBaseUrl(): ?string
    {
        return $this->baseUrl;
    }

    public function setBaseUrl(?string $baseUrl): static
    {
        $this->baseUrl = $baseUrl;
        return $this;
    }

    public function getLocaleDefault(): string
    {
        return $this->localeDefault;
    }

    public function setLocaleDefault(string $localeDefault): static
    {
        $this->localeDefault = $localeDefault;
        return $this;
    }

    public function getMaxPlusOnesPerHousehold(): int
    {
        return $this->maxPlusOnesPerHousehold;
    }

    public function setMaxPlusOnesPerHousehold(?int $maxPlusOnesPerHousehold): static
    {
        $this->maxPlusOnesPerHousehold = $maxPlusOnesPerHousehold;
        return $this;
    }

    public function getSmtpHost(): ?string
    {
        return $this->smtpHost;
    }

    public function setSmtpHost(?string $smtpHost): static
    {
        $this->smtpHost = $smtpHost;
        return $this;
    }

    public function getSmtpPort(): ?int
    {
        return $this->smtpPort;
    }

    public function setSmtpPort(?int $smtpPort): static
    {
        $this->smtpPort = $smtpPort;
        return $this;
    }

    public function getSmtpUsername(): ?string
    {
        return $this->smtpUsername;
    }

    public function setSmtpUsername(?string $smtpUsername): static
    {
        $this->smtpUsername = $smtpUsername;
        return $this;
    }

    public function getSmtpPassword(): ?string
    {
        return $this->smtpPassword;
    }

    public function setSmtpPassword(?string $smtpPassword): static
    {
        $this->smtpPassword = $smtpPassword;
        return $this;
    }

    public function getSmtpEncryption(): ?string
    {
        return $this->smtpEncryption;
    }

    public function setSmtpEncryption(?string $smtpEncryption): static
    {
        $this->smtpEncryption = $smtpEncryption;
        return $this;
    }

    public function getEmailFromAddress(): ?string
    {
        return $this->emailFromAddress;
    }

    public function setEmailFromAddress(?string $emailFromAddress): static
    {
        $this->emailFromAddress = $emailFromAddress;
        return $this;
    }

    public function getEmailFromName(): ?string
    {
        return $this->emailFromName;
    }

    public function setEmailFromName(?string $emailFromName): static
    {
        $this->emailFromName = $emailFromName;
        return $this;
    }

    public function getInviteEmailSubject(): ?string
    {
        return $this->inviteEmailSubject;
    }

    public function setInviteEmailSubject(?string $inviteEmailSubject): static
    {
        $this->inviteEmailSubject = $inviteEmailSubject;
        return $this;
    }

    public function getInviteEmailBody(): ?string
    {
        return $this->inviteEmailBody;
    }

    public function setInviteEmailBody(?string $inviteEmailBody): static
    {
        $this->inviteEmailBody = $inviteEmailBody;
        return $this;
    }

    public function getReminderEmailSubject(): ?string
    {
        return $this->reminderEmailSubject;
    }

    public function setReminderEmailSubject(?string $reminderEmailSubject): static
    {
        $this->reminderEmailSubject = $reminderEmailSubject;
        return $this;
    }

    public function getReminderEmailBody(): ?string
    {
        return $this->reminderEmailBody;
    }

    public function setReminderEmailBody(?string $reminderEmailBody): static
    {
        $this->reminderEmailBody = $reminderEmailBody;
        return $this;
    }

    public function getEmailButtonText(): ?string
    {
        return $this->emailButtonText;
    }

    public function setEmailButtonText(?string $emailButtonText): static
    {
        $this->emailButtonText = $emailButtonText;
        return $this;
    }

    public function getEmailButtonColor(): ?string
    {
        return $this->emailButtonColor;
    }

    public function setEmailButtonColor(?string $emailButtonColor): static
    {
        $this->emailButtonColor = $emailButtonColor;
        return $this;
    }

    public function getEmailCallToAction(): ?string
    {
        return $this->emailCallToAction;
    }

    public function setEmailCallToAction(?string $emailCallToAction): static
    {
        $this->emailCallToAction = $emailCallToAction;
        return $this;
    }

    public function getEmailClosingText(): ?string
    {
        return $this->emailClosingText;
    }

    public function setEmailClosingText(?string $emailClosingText): static
    {
        $this->emailClosingText = $emailClosingText;
        return $this;
    }

    public function getEmailSignature(): ?string
    {
        return $this->emailSignature;
    }

    public function setEmailSignature(?string $emailSignature): static
    {
        $this->emailSignature = $emailSignature;
        return $this;
    }

    public function getTicketEmailSubject(): ?string
    {
        return $this->ticketEmailSubject;
    }

    public function setTicketEmailSubject(?string $ticketEmailSubject): static
    {
        $this->ticketEmailSubject = $ticketEmailSubject;
        return $this;
    }

    public function getTicketEmailBody(): ?string
    {
        return $this->ticketEmailBody;
    }

    public function setTicketEmailBody(?string $ticketEmailBody): static
    {
        $this->ticketEmailBody = $ticketEmailBody;
        return $this;
    }

    public function getTicketEmailGreeting(): ?string
    {
        return $this->ticketEmailGreeting;
    }

    public function setTicketEmailGreeting(?string $ticketEmailGreeting): static
    {
        $this->ticketEmailGreeting = $ticketEmailGreeting;
        return $this;
    }

    public function getTicketEmailIntro(): ?string
    {
        return $this->ticketEmailIntro;
    }

    public function setTicketEmailIntro(?string $ticketEmailIntro): static
    {
        $this->ticketEmailIntro = $ticketEmailIntro;
        return $this;
    }

    public function getTicketEmailButtonText(): ?string
    {
        return $this->ticketEmailButtonText;
    }

    public function setTicketEmailButtonText(?string $ticketEmailButtonText): static
    {
        $this->ticketEmailButtonText = $ticketEmailButtonText;
        return $this;
    }

    public function getTicketEmailInstructions(): ?string
    {
        return $this->ticketEmailInstructions;
    }

    public function setTicketEmailInstructions(?string $ticketEmailInstructions): static
    {
        $this->ticketEmailInstructions = $ticketEmailInstructions;
        return $this;
    }

    public function getTicketEmailClosing(): ?string
    {
        return $this->ticketEmailClosing;
    }

    public function setTicketEmailClosing(?string $ticketEmailClosing): static
    {
        $this->ticketEmailClosing = $ticketEmailClosing;
        return $this;
    }

    public function getTicketEmailFooter(): ?string
    {
        return $this->ticketEmailFooter;
    }

    public function setTicketEmailFooter(?string $ticketEmailFooter): static
    {
        $this->ticketEmailFooter = $ticketEmailFooter;
        return $this;
    }
}
