<?php

namespace App\Entity;

use App\Repository\HouseholdEventRsvpRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: HouseholdEventRsvpRepository::class)]
#[ORM\UniqueConstraint(name: 'UNIQ_HOUSEHOLD_EVENT', columns: ['household_id', 'event_id'])]
class HouseholdEventRsvp
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(targetEntity: Household::class, inversedBy: 'rsvps')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Household $household = null;

    #[ORM\ManyToOne(targetEntity: Event::class)]
    #[ORM\JoinColumn(nullable: false)]
    private ?Event $event = null;

    #[ORM\Column(length: 20, nullable: true)]
    private ?string $status = null;

    #[ORM\Column(type: Types::SMALLINT)]
    private int $adultsCount = 0;

    #[ORM\Column(type: Types::SMALLINT)]
    private int $childrenCount = 0;

    #[ORM\Column(type: Types::JSON, nullable: true)]
    private ?array $mealCountsJson = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $dietary = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $namesText = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $messageToCouple = null;

    #[ORM\Column(type: Types::JSON, nullable: true)]
    private ?array $guestDetailsJson = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $respondedAt = null;

    #[ORM\Column(type: Types::BOOLEAN)]
    private bool $checkedIn = false;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $checkedInAt = null;

    #[ORM\ManyToOne(targetEntity: User::class)]
    #[ORM\JoinColumn(nullable: true)]
    private ?User $checkedInByUser = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getHousehold(): ?Household
    {
        return $this->household;
    }

    public function setHousehold(?Household $household): static
    {
        $this->household = $household;
        return $this;
    }

    public function getEvent(): ?Event
    {
        return $this->event;
    }

    public function setEvent(?Event $event): static
    {
        $this->event = $event;
        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): static
    {
        $this->status = $status;
        return $this;
    }

    public function getAdultsCount(): int
    {
        return $this->adultsCount;
    }

    public function setAdultsCount(int $adultsCount): static
    {
        $this->adultsCount = $adultsCount;
        return $this;
    }

    public function getChildrenCount(): int
    {
        return $this->childrenCount;
    }

    public function setChildrenCount(int $childrenCount): static
    {
        $this->childrenCount = $childrenCount;
        return $this;
    }

    public function getMealCountsJson(): ?array
    {
        return $this->mealCountsJson;
    }

    public function setMealCountsJson(?array $mealCountsJson): static
    {
        $this->mealCountsJson = $mealCountsJson;
        return $this;
    }

    public function getDietary(): ?string
    {
        return $this->dietary;
    }

    public function setDietary(?string $dietary): static
    {
        $this->dietary = $dietary;
        return $this;
    }

    public function getNamesText(): ?string
    {
        return $this->namesText;
    }

    public function setNamesText(?string $namesText): static
    {
        $this->namesText = $namesText;
        return $this;
    }

    public function getMessageToCouple(): ?string
    {
        return $this->messageToCouple;
    }

    public function setMessageToCouple(?string $messageToCouple): static
    {
        $this->messageToCouple = $messageToCouple;
        return $this;
    }

    public function getGuestDetailsJson(): ?array
    {
        return $this->guestDetailsJson;
    }

    public function setGuestDetailsJson(?array $guestDetailsJson): static
    {
        $this->guestDetailsJson = $guestDetailsJson;
        return $this;
    }

    public function getRespondedAt(): ?\DateTimeInterface
    {
        return $this->respondedAt;
    }

    public function setRespondedAt(?\DateTimeInterface $respondedAt): static
    {
        $this->respondedAt = $respondedAt;
        return $this;
    }

    public function getTotalCount(): int
    {
        return $this->adultsCount + $this->childrenCount;
    }

    public function isCheckedIn(): bool
    {
        return $this->checkedIn;
    }

    public function setCheckedIn(bool $checkedIn): static
    {
        $this->checkedIn = $checkedIn;
        return $this;
    }

    public function getCheckedInAt(): ?\DateTimeInterface
    {
        return $this->checkedInAt;
    }

    public function setCheckedInAt(?\DateTimeInterface $checkedInAt): static
    {
        $this->checkedInAt = $checkedInAt;
        return $this;
    }

    public function getCheckedInByUser(): ?User
    {
        return $this->checkedInByUser;
    }

    public function setCheckedInByUser(?User $user): static
    {
        $this->checkedInByUser = $user;
        return $this;
    }
}
