<?php

namespace App\Entity;

use App\Repository\EventRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: EventRepository::class)]
class Event
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $name = null;

    #[ORM\Column(length: 255, unique: true)]
    private ?string $slug = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $venueName = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $venueAddress = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $description = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $startAt = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $endAt = null;

    #[ORM\Column(nullable: true)]
    private ?int $capacity = null;

    #[ORM\Column]
    private bool $isPublic = true;

    #[ORM\Column(name: 'display_order')]
    private int $displayOrder = 0;

    #[ORM\Column]
    private bool $mealsEnabled = false;

    #[ORM\Column(type: Types::JSON, nullable: true)]
    private ?array $mealOptionsJson = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $nameFont = 'Bodoni Moda';

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nameOne = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nameTwo = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $andText = 'AND';

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;
        // Auto-generate slug from name if not set
        if (!$this->slug) {
            $this->slug = $this->generateSlug($name);
        }
        return $this;
    }

    public function getSlug(): ?string
    {
        return $this->slug;
    }

    public function setSlug(string $slug): static
    {
        $this->slug = $this->generateSlug($slug);
        return $this;
    }

    private function generateSlug(string $text): string
    {
        // Convert to lowercase and replace spaces with hyphens
        $slug = strtolower(trim($text));
        $slug = preg_replace('/[^a-z0-9-]/', '-', $slug);
        $slug = preg_replace('/-+/', '-', $slug);
        return trim($slug, '-');
    }

    public function getVenueName(): ?string
    {
        return $this->venueName;
    }

    public function setVenueName(?string $venueName): static
    {
        $this->venueName = $venueName;
        return $this;
    }

    public function getVenueAddress(): ?string
    {
        return $this->venueAddress;
    }

    public function setVenueAddress(?string $venueAddress): static
    {
        $this->venueAddress = $venueAddress;
        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): static
    {
        $this->description = $description;
        return $this;
    }

    public function getStartAt(): ?\DateTimeInterface
    {
        return $this->startAt;
    }

    public function setStartAt(?\DateTimeInterface $startAt): static
    {
        $this->startAt = $startAt;
        return $this;
    }

    public function getEndAt(): ?\DateTimeInterface
    {
        return $this->endAt;
    }

    public function setEndAt(?\DateTimeInterface $endAt): static
    {
        $this->endAt = $endAt;
        return $this;
    }

    public function getCapacity(): ?int
    {
        return $this->capacity;
    }

    public function setCapacity(?int $capacity): static
    {
        $this->capacity = $capacity;
        return $this;
    }

    public function isPublic(): bool
    {
        return $this->isPublic;
    }

    public function setIsPublic(bool $isPublic): static
    {
        $this->isPublic = $isPublic;
        return $this;
    }

    public function getDisplayOrder(): int
    {
        return $this->displayOrder;
    }

    public function setDisplayOrder(int $displayOrder): static
    {
        $this->displayOrder = $displayOrder;
        return $this;
    }

    // Backward compatibility alias
    public function getOrder(): int
    {
        return $this->displayOrder;
    }

    public function setOrder(int $order): static
    {
        $this->displayOrder = $order;
        return $this;
    }

    public function isMealsEnabled(): bool
    {
        return $this->mealsEnabled;
    }

    public function setMealsEnabled(bool $mealsEnabled): static
    {
        $this->mealsEnabled = $mealsEnabled;
        return $this;
    }

    public function getMealOptionsJson(): ?array
    {
        return $this->mealOptionsJson;
    }

    public function setMealOptionsJson(?array $mealOptionsJson): static
    {
        $this->mealOptionsJson = $mealOptionsJson;
        return $this;
    }

    public function getNameFont(): ?string
    {
        return $this->nameFont;
    }

    public function setNameFont(?string $nameFont): static
    {
        $this->nameFont = $nameFont;
        return $this;
    }

    public function getNameOne(): ?string
    {
        return $this->nameOne;
    }

    public function setNameOne(?string $nameOne): static
    {
        $this->nameOne = $nameOne;
        return $this;
    }

    public function getNameTwo(): ?string
    {
        return $this->nameTwo;
    }

    public function setNameTwo(?string $nameTwo): static
    {
        $this->nameTwo = $nameTwo;
        return $this;
    }

    public function getAndText(): ?string
    {
        return $this->andText;
    }

    public function setAndText(?string $andText): static
    {
        $this->andText = $andText;
        return $this;
    }
}
