<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\KernelInterface;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Filesystem\Filesystem;

class InstallerController extends AbstractController
{
    #[Route('/install', name: 'installer_index')]
    public function index(): Response
    {
        return $this->render('install/installer.html.twig');
    }


    #[Route('/clear-cache', name: 'installer_clear_cache_alt')]
    public function clearCache(KernelInterface $kernel): Response
    {
        $projectDir = $kernel->getProjectDir();
        $success = false;
        $message = '';
        $debug = [];
        
        try {
            $phpBinary = PHP_BINARY;
            $consolePath = $projectDir . '/bin/console';
            
            $debug[] = 'PHP Binary: ' . $phpBinary;
            $debug[] = 'Console Path: ' . $consolePath;
            $debug[] = 'Console exists: ' . (file_exists($consolePath) ? 'Yes' : 'No');
            
            // Try multiple approaches
            
            // Approach 1: Direct filesystem removal
            $filesystem = new Filesystem();
            $prodCacheDir = $projectDir . '/var/cache/prod';
            
            if (is_dir($prodCacheDir)) {
                try {
                    // Try to remove it directly
                    $filesystem->remove($prodCacheDir);
                    $success = true;
                    $message = 'Cache cleared successfully using direct removal!';
                } catch (\Exception $e) {
                    $debug[] = 'Direct removal failed: ' . $e->getMessage();
                    
                    // Approach 2: Use exec with cache:clear
                    $command = sprintf(
                        '"%s" "%s" cache:clear --env=prod --no-warmup 2>&1',
                        $phpBinary,
                        $consolePath
                    );
                    
                    $debug[] = 'Command: ' . $command;
                    
                    exec($command, $output, $returnCode);
                    
                    $debug[] = 'Return code: ' . $returnCode;
                    $debug[] = 'Output: ' . implode("\n", $output);
                    
                    if ($returnCode === 0) {
                        $success = true;
                        $message = 'Cache cleared successfully using console command!';
                    } else {
                        $message = 'Failed to clear cache. See debug info below.';
                    }
                }
            } else {
                $success = true;
                $message = 'No cache directory found. Cache is already clear.';
            }
            
        } catch (\Exception $e) {
            $message = 'Error: ' . $e->getMessage();
            $debug[] = 'Exception: ' . $e->getTraceAsString();
        }
        
        return $this->render('install/clear_cache.html.twig', [
            'success' => $success,
            'message' => $message,
            'debug' => $debug
        ]);
    }
}
