<?php

namespace App\Controller;

use App\Repository\EventRepository;
use App\Service\IcsService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class IcsController extends AbstractController
{
    public function __construct(
        private EventRepository $eventRepo,
        private IcsService $icsService
    ) {
    }

    #[Route('/ics/event/{id}', name: 'ics_event')]
    public function eventFile(int $id): Response
    {
        $event = $this->eventRepo->find($id);
        
        if (!$event) {
            throw $this->createNotFoundException('Event not found');
        }

        $ics = $this->icsService->generateIcs($event);
        
        $response = new Response($ics);
        $response->headers->set('Content-Type', 'text/calendar; charset=utf-8');
        $response->headers->set('Content-Disposition', 'attachment; filename="' . $event->getName() . '.ics"');

        return $response;
    }
}
