<?php

namespace App\Controller;

use App\Repository\SettingRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class CheckinController extends AbstractController
{
    public function __construct(
        private SettingRepository $settingRepo
    ) {
    }

    #[Route('/checkin', name: 'checkin_scanner')]
    public function scanner(Request $request): Response
    {
        $session = $request->getSession();
        $settings = $this->settingRepo->findFirst();

        // Check if PIN is valid
        if ($request->isMethod('POST')) {
            $pin = $request->request->get('pin');
            if ($pin === $settings->getStaffPin()) {
                $session->set('checkin_authorized', true);
                return $this->redirectToRoute('checkin_scanner');
            }
            $this->addFlash('error', 'Invalid PIN');
        }

        if (!$session->get('checkin_authorized')) {
            return $this->render('checkin/pin.html.twig');
        }

        return $this->render('checkin/scanner.html.twig');
    }

    #[Route('/checkin/logout', name: 'checkin_logout')]
    public function logout(Request $request): Response
    {
        $request->getSession()->remove('checkin_authorized');
        return $this->redirectToRoute('checkin_scanner');
    }
}
