<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

final class AdminController extends AbstractController
{
    #[Route('/admin/{react}', name: 'app_admin', requirements: ['react' => '^(?!api|auth|register|login|logout|front|user|@|public|install|_(profiler|wdt)).*'] )]
    public function index($react = null): Response
    {
        if (!$this->isGranted('ROLE_ADMIN')) {
            return $this->redirectToRoute('app_login');
        }
        return $this->render('admin/index.html.twig', []);
    }
}
