<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Add ticket email template fields to setting table
 */
final class Version20251031184700 extends AbstractMigration
{
    public function getDescription(): string
    {
        return 'Add ticket_email_subject and ticket_email_body fields to setting table for customizable QR ticket emails';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE setting ADD ticket_email_subject VARCHAR(255) DEFAULT \'Your QR Code Ticket for {eventName}\' NULL');
        $this->addSql('ALTER TABLE setting ADD ticket_email_body TEXT DEFAULT NULL');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE setting DROP ticket_email_subject');
        $this->addSql('ALTER TABLE setting DROP ticket_email_body');
    }
}
