<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Add customizable email template options
 */
final class Version20251029200000 extends AbstractMigration
{
    public function getDescription(): string
    {
        return 'Add customizable options for email templates (button text, colors, etc.)';
    }

    public function up(Schema $schema): void
    {
        $this->addSql('ALTER TABLE setting ADD COLUMN IF NOT EXISTS email_button_text VARCHAR(100) DEFAULT "RSVP Now"');
        $this->addSql('ALTER TABLE setting ADD COLUMN IF NOT EXISTS email_button_color VARCHAR(20) DEFAULT "#c2185b"');
        $this->addSql('ALTER TABLE setting ADD COLUMN IF NOT EXISTS email_call_to_action VARCHAR(255) DEFAULT "Please RSVP by clicking the button below:"');
        $this->addSql('ALTER TABLE setting ADD COLUMN IF NOT EXISTS email_closing_text VARCHAR(255) DEFAULT "We can\'\'t wait to celebrate with you!"');
        $this->addSql('ALTER TABLE setting ADD COLUMN IF NOT EXISTS email_signature TEXT DEFAULT NULL');
    }

    public function down(Schema $schema): void
    {
        $this->addSql('ALTER TABLE setting DROP COLUMN email_button_text');
        $this->addSql('ALTER TABLE setting DROP COLUMN email_button_color');
        $this->addSql('ALTER TABLE setting DROP COLUMN email_call_to_action');
        $this->addSql('ALTER TABLE setting DROP COLUMN email_closing_text');
        $this->addSql('ALTER TABLE setting DROP COLUMN email_signature');
    }
}
