<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Add email template fields to setting table
 */
final class Version20251029184700 extends AbstractMigration
{
    public function getDescription(): string
    {
        return 'Add customizable email template fields for invites and reminders';
    }

    public function up(Schema $schema): void
    {
        $this->addSql('ALTER TABLE setting ADD invite_email_subject VARCHAR(255) DEFAULT "You\'re Invited to Our Wedding!"');
        $this->addSql('ALTER TABLE setting ADD invite_email_body LONGTEXT DEFAULT NULL');
        $this->addSql('ALTER TABLE setting ADD reminder_email_subject VARCHAR(255) DEFAULT "Reminder: Please RSVP to Our Wedding"');
        $this->addSql('ALTER TABLE setting ADD reminder_email_body LONGTEXT DEFAULT NULL');
    }

    public function down(Schema $schema): void
    {
        $this->addSql('ALTER TABLE setting DROP invite_email_subject');
        $this->addSql('ALTER TABLE setting DROP invite_email_body');
        $this->addSql('ALTER TABLE setting DROP reminder_email_subject');
        $this->addSql('ALTER TABLE setting DROP reminder_email_body');
    }
}
