<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Add individual guest details support (names, meal choices, dietary restrictions)
 */
final class Version20251029170500 extends AbstractMigration
{
    public function getDescription(): string
    {
        return 'Add columns to guest table for individual guest details from RSVP form';
    }

    public function up(Schema $schema): void
    {
        // Add columns to guest table for detailed individual information
        $this->addSql('ALTER TABLE guest ADD type VARCHAR(20) DEFAULT "ADULT" COMMENT "ADULT or CHILD"');
        $this->addSql('ALTER TABLE guest ADD meal_choice VARCHAR(100) DEFAULT NULL COMMENT "Meal selection from RSVP"');
        $this->addSql('ALTER TABLE guest ADD dietary_restrictions TEXT DEFAULT NULL COMMENT "Dietary restrictions/allergies"');
        $this->addSql('ALTER TABLE guest ADD attending TINYINT(1) DEFAULT NULL COMMENT "Whether guest is attending"');
        $this->addSql('ALTER TABLE guest ADD notes TEXT DEFAULT NULL COMMENT "Additional notes from RSVP"');
    }

    public function down(Schema $schema): void
    {
        // Remove the added columns
        $this->addSql('ALTER TABLE guest DROP type');
        $this->addSql('ALTER TABLE guest DROP meal_choice');
        $this->addSql('ALTER TABLE guest DROP dietary_restrictions');
        $this->addSql('ALTER TABLE guest DROP attending');
        $this->addSql('ALTER TABLE guest DROP notes');
    }
}
