-- =====================================================
-- RSVP Application - Demo Data
-- =====================================================
-- WARNING: This will delete existing data!
-- Only use in development/demo environments
-- =====================================================

SET FOREIGN_KEY_CHECKS=0;

-- Clear existing data
TRUNCATE TABLE `checkin`;
TRUNCATE TABLE `household_event_rsvp`;
TRUNCATE TABLE `rsvp`;
TRUNCATE TABLE `guest`;
TRUNCATE TABLE `household`;
TRUNCATE TABLE `event`;

SET FOREIGN_KEY_CHECKS=1;

-- =====================================================
-- Events
-- =====================================================

INSERT INTO `event` (`id`, `name`, `slug`, `name_one`, `name_two`, `and_text`, `venue_name`, `venue_address`, `description`, `start_at`, `end_at`, `capacity`, `is_public`, `display_order`, `meals_enabled`, `meal_options_json`, `name_font`) VALUES
(1, 'Wedding Ceremony', 'ceremony', 'Sarah', 'Michael', '&', 'Grand Oak Chapel', '123 Chapel Lane, Austin, TX 78701', 'Join us as we say "I do" in an intimate ceremony surrounded by our loved ones.', DATE_ADD(NOW(), INTERVAL 2 MONTH), DATE_ADD(DATE_ADD(NOW(), INTERVAL 2 MONTH), INTERVAL 90 MINUTE), 150, 1, 1, 1, '[{"code":"beef","name":"Herb-Crusted Beef Tenderloin"},{"code":"chicken","name":"Lemon Rosemary Chicken"},{"code":"salmon","name":"Pan-Seared Salmon"},{"code":"vegan","name":"Roasted Vegetable Wellington"}]', 'Bodoni Moda'),
(2, 'Reception & Dinner', 'reception', 'Sarah', 'Michael', '&', 'Riverside Ballroom', '456 River Road, Austin, TX 78701', 'Celebrate with us at an evening of dinner, dancing, and joy!', DATE_ADD(DATE_ADD(NOW(), INTERVAL 2 MONTH), INTERVAL 4 HOUR), DATE_ADD(DATE_ADD(NOW(), INTERVAL 2 MONTH), INTERVAL 9 HOUR), 200, 1, 2, 1, '[{"code":"beef","name":"Herb-Crusted Beef Tenderloin"},{"code":"chicken","name":"Lemon Rosemary Chicken"},{"code":"salmon","name":"Pan-Seared Salmon"},{"code":"vegan","name":"Roasted Vegetable Wellington"}]', 'Bodoni Moda');

-- =====================================================
-- Households
-- =====================================================

INSERT INTO `household` (`id`, `display_name`, `email`, `phone`, `address`, `side`, `locale`, `token`, `invited_at`, `number_of_adults`, `number_of_children`) VALUES
(1, 'The Johnson Family', 'johnson@example.com', '555-0101', '789 Oak Street, Austin, TX 78702', 'BRIDE', 'en', 'abc123def456ghi789jk', DATE_SUB(NOW(), INTERVAL 15 DAY), 2, 1),
(2, 'The Martinez Family', 'martinez@example.com', '555-0102', '321 Pine Avenue, Austin, TX 78703', 'GROOM', 'en', 'mno234pqr567stu890vw', DATE_SUB(NOW(), INTERVAL 20 DAY), 2, 0),
(3, 'The Thompson Family', 'thompson@example.com', '555-0103', '567 Maple Drive, Austin, TX 78704', 'BRIDE', 'en', 'xyz345abc678def901gh', DATE_SUB(NOW(), INTERVAL 10 DAY), 2, 2),
(4, 'The Davis Family', 'davis@example.com', '555-0104', '890 Cedar Lane, Austin, TX 78705', 'GROOM', 'en', 'ijk456lmn789opq012rs', DATE_SUB(NOW(), INTERVAL 25 DAY), 2, 0),
(5, 'The Anderson Family', 'anderson@example.com', '555-0105', '234 Birch Street, Austin, TX 78706', 'BRIDE', 'en', 'tuv567wxy890zab123cd', DATE_SUB(NOW(), INTERVAL 12 DAY), 2, 1),
(6, 'The Wilson Family', 'wilson@example.com', '555-0106', '678 Elm Avenue, Austin, TX 78707', 'GROOM', 'en', 'efg678hij901klm234no', DATE_SUB(NOW(), INTERVAL 8 DAY), 2, 0),
(7, 'The Garcia Family', 'garcia@example.com', '555-0107', '912 Spruce Road, Austin, TX 78708', 'BRIDE', 'en', 'pqr789stu012vwx345yz', NULL, 2, 1),
(8, 'The Brown Family', 'brown@example.com', '555-0108', '345 Walnut Place, Austin, TX 78709', 'GROOM', 'en', 'abc890def123ghi456jk', DATE_SUB(NOW(), INTERVAL 18 DAY), 2, 0),
(9, 'The Lee Family', 'lee@example.com', '555-0109', '789 Cherry Drive, Austin, TX 78710', 'BRIDE', 'en', 'lmn901opq234rst567uv', NULL, 2, 1),
(10, 'The Miller Family', 'miller@example.com', '555-0110', '456 Poplar Lane, Austin, TX 78711', 'GROOM', 'en', 'wxy012zab345cde678fg', DATE_SUB(NOW(), INTERVAL 5 DAY), 1, 0);

-- =====================================================
-- Guests
-- =====================================================

INSERT INTO `guest` (`household_id`, `first_name`, `last_name`, `email`, `phone`, `is_child`, `side`) VALUES
-- Johnson Family (id=1)
(1, 'James', 'Johnson', 'johnson@example.com', '555-0101', 0, 'BRIDE'),
(1, 'Emily', 'Johnson', 'johnson@example.com', '555-0101', 0, 'BRIDE'),
(1, 'Sophie', 'Johnson', 'johnson@example.com', '555-0101', 1, 'BRIDE'),
-- Martinez Family (id=2)
(2, 'Carlos', 'Martinez', 'martinez@example.com', '555-0102', 0, 'GROOM'),
(2, 'Maria', 'Martinez', 'martinez@example.com', '555-0102', 0, 'GROOM'),
-- Thompson Family (id=3)
(3, 'Robert', 'Thompson', 'thompson@example.com', '555-0103', 0, 'BRIDE'),
(3, 'Jennifer', 'Thompson', 'thompson@example.com', '555-0103', 0, 'BRIDE'),
(3, 'Lucas', 'Thompson', 'thompson@example.com', '555-0103', 1, 'BRIDE'),
(3, 'Emma', 'Thompson', 'thompson@example.com', '555-0103', 1, 'BRIDE'),
-- Davis Family (id=4)
(4, 'Michael', 'Davis', 'davis@example.com', '555-0104', 0, 'GROOM'),
(4, 'Sarah', 'Davis', 'davis@example.com', '555-0104', 0, 'GROOM'),
-- Anderson Family (id=5)
(5, 'David', 'Anderson', 'anderson@example.com', '555-0105', 0, 'BRIDE'),
(5, 'Lisa', 'Anderson', 'anderson@example.com', '555-0105', 0, 'BRIDE'),
(5, 'Noah', 'Anderson', 'anderson@example.com', '555-0105', 1, 'BRIDE'),
-- Wilson Family (id=6)
(6, 'Thomas', 'Wilson', 'wilson@example.com', '555-0106', 0, 'GROOM'),
(6, 'Jessica', 'Wilson', 'wilson@example.com', '555-0106', 0, 'GROOM'),
-- Garcia Family (id=7)
(7, 'Jose', 'Garcia', 'garcia@example.com', '555-0107', 0, 'BRIDE'),
(7, 'Ana', 'Garcia', 'garcia@example.com', '555-0107', 0, 'BRIDE'),
(7, 'Isabella', 'Garcia', 'garcia@example.com', '555-0107', 1, 'BRIDE'),
-- Brown Family (id=8)
(8, 'Christopher', 'Brown', 'brown@example.com', '555-0108', 0, 'GROOM'),
(8, 'Amanda', 'Brown', 'brown@example.com', '555-0108', 0, 'GROOM'),
-- Lee Family (id=9)
(9, 'Kevin', 'Lee', 'lee@example.com', '555-0109', 0, 'BRIDE'),
(9, 'Michelle', 'Lee', 'lee@example.com', '555-0109', 0, 'BRIDE'),
(9, 'Ethan', 'Lee', 'lee@example.com', '555-0109', 1, 'BRIDE'),
-- Miller Family (id=10)
(10, 'Daniel', 'Miller', 'miller@example.com', '555-0110', 0, 'GROOM');

-- =====================================================
-- RSVPs - Ceremony Event (Event ID 1)
-- =====================================================

-- YES responses with meal choices
INSERT INTO `household_event_rsvp` (`household_id`, `event_id`, `status`, `adults_count`, `children_count`, `responded_at`, `message`, `guest_details_json`) VALUES
(1, 1, 'YES', 2, 1, DATE_SUB(NOW(), INTERVAL 10 DAY), 'So excited to celebrate with you!', '{"adults":[{"name":"James Johnson","meal":"beef","dietary":""},{"name":"Emily Johnson","meal":"chicken","dietary":""}],"children":[{"name":"Sophie Johnson","meal":"chicken","dietary":""}]}'),
(2, 1, 'YES', 2, 0, DATE_SUB(NOW(), INTERVAL 15 DAY), 'Looking forward to the celebration!', '{"adults":[{"name":"Carlos Martinez","meal":"salmon","dietary":""},{"name":"Maria Martinez","meal":"vegan","dietary":""}]}'),
(3, 1, 'YES', 2, 2, DATE_SUB(NOW(), INTERVAL 5 DAY), NULL, '{"adults":[{"name":"Robert Thompson","meal":"beef","dietary":""},{"name":"Jennifer Thompson","meal":"salmon","dietary":""}],"children":[{"name":"Lucas Thompson","meal":"chicken","dietary":""},{"name":"Emma Thompson","meal":"chicken","dietary":""}]}'),
(6, 1, 'YES', 2, 0, DATE_SUB(NOW(), INTERVAL 3 DAY), 'Can\'t wait!', '{"adults":[{"name":"Thomas Wilson","meal":"chicken","dietary":""},{"name":"Jessica Wilson","meal":"vegan","dietary":"Gluten-free"}]}'),
(8, 1, 'YES', 2, 0, DATE_SUB(NOW(), INTERVAL 12 DAY), NULL, '{"adults":[{"name":"Christopher Brown","meal":"beef","dietary":""},{"name":"Amanda Brown","meal":"salmon","dietary":""}]}'),
(10, 1, 'YES', 1, 0, DATE_SUB(NOW(), INTERVAL 2 DAY), 'Congratulations!', '{"adults":[{"name":"Daniel Miller","meal":"chicken","dietary":""}]}'),
-- NO response
(4, 1, 'NO', 0, 0, DATE_SUB(NOW(), INTERVAL 8 DAY), 'Sorry we can\'t make it. Wishing you all the best!', NULL),
-- MAYBE response
(5, 1, 'MAYBE', 0, 0, DATE_SUB(NOW(), INTERVAL 6 DAY), 'Will confirm soon!', NULL);

-- =====================================================
-- RSVPs - Reception Event (Event ID 2)
-- =====================================================

INSERT INTO `household_event_rsvp` (`household_id`, `event_id`, `status`, `adults_count`, `children_count`, `responded_at`, `message`, `guest_details_json`) VALUES
(1, 2, 'YES', 2, 1, DATE_SUB(NOW(), INTERVAL 10 DAY), 'So excited to celebrate with you!', '{"adults":[{"name":"James Johnson","meal":"beef","dietary":""},{"name":"Emily Johnson","meal":"chicken","dietary":""}],"children":[{"name":"Sophie Johnson","meal":"chicken","dietary":""}]}'),
(2, 2, 'YES', 2, 0, DATE_SUB(NOW(), INTERVAL 15 DAY), 'Looking forward to the celebration!', '{"adults":[{"name":"Carlos Martinez","meal":"salmon","dietary":""},{"name":"Maria Martinez","meal":"vegan","dietary":""}]}'),
(3, 2, 'YES', 2, 2, DATE_SUB(NOW(), INTERVAL 5 DAY), NULL, '{"adults":[{"name":"Robert Thompson","meal":"beef","dietary":""},{"name":"Jennifer Thompson","meal":"salmon","dietary":""}],"children":[{"name":"Lucas Thompson","meal":"chicken","dietary":""},{"name":"Emma Thompson","meal":"chicken","dietary":""}]}'),
(6, 2, 'YES', 2, 0, DATE_SUB(NOW(), INTERVAL 3 DAY), 'Can\'t wait!', '{"adults":[{"name":"Thomas Wilson","meal":"chicken","dietary":""},{"name":"Jessica Wilson","meal":"vegan","dietary":"Gluten-free"}]}'),
(8, 2, 'YES', 2, 0, DATE_SUB(NOW(), INTERVAL 12 DAY), NULL, '{"adults":[{"name":"Christopher Brown","meal":"beef","dietary":""},{"name":"Amanda Brown","meal":"salmon","dietary":""}]}'),
(10, 2, 'YES', 1, 0, DATE_SUB(NOW(), INTERVAL 2 DAY), 'Congratulations!', '{"adults":[{"name":"Daniel Miller","meal":"chicken","dietary":""}]}'),
(4, 2, 'NO', 0, 0, DATE_SUB(NOW(), INTERVAL 8 DAY), 'Sorry we can\'t make it. Wishing you all the best!', NULL),
(5, 2, 'MAYBE', 0, 0, DATE_SUB(NOW(), INTERVAL 6 DAY), 'Will confirm soon!', NULL);

-- =====================================================
-- Summary
-- =====================================================
-- Events: 2 (Ceremony & Reception)
-- Households: 10
-- Guests: 25 (adults and children)
-- RSVPs: 
--   - YES: 6 households (12 adults, 4 children)
--   - NO: 1 household
--   - MAYBE: 1 household
--   - Not Responded: 2 households
-- =====================================================

SELECT 'Demo data loaded successfully!' as status;
