import React from 'react';

export default function SuccessView({ data, styles }) {
    const { settings, events } = data;
    
    // Only show events that have been RSVP'd as YES
    const rsvpedEvents = events.filter(event => {
        // Check if there's a YES RSVP status
        if (event.rsvp && event.rsvp.status === 'YES') return true;
        if (event.guests && event.guests.some(g => g.status === 'YES')) return true;
        return false;
    });
    
    return (
        <div style={{ background: styles.bg }} className="min-h-screen flex items-center justify-center p-6">
            <div className="max-w-2xl w-full text-center" style={{ paddingTop: '80px', paddingBottom: '80px' }}>
                <h1 
                    style={{ 
                        fontFamily: "'Playfair Display', serif",
                        fontSize: '2.5rem',
                        color: styles.ink,
                        letterSpacing: '0.15em',
                        lineHeight: '1.2',
                        marginBottom: '32px'
                    }}
                >
                    THANK YOU FOR YOUR RESPONSE
                </h1>
                <p style={{ 
                    fontFamily: 'Inter, sans-serif', 
                    color: styles.inkSoft, 
                    fontSize: '1.125rem',
                    lineHeight: '1.7',
                    maxWidth: '560px',
                    margin: '0 auto 24px'
                }}>
                    Your RSVP has been submitted successfully.
                </p>
                <p style={{ 
                    fontFamily: 'Inter, sans-serif', 
                    color: styles.inkSoft, 
                    fontSize: '1.125rem',
                    marginBottom: '48px'
                }}>
                    We can't wait to celebrate with you!
                </p>

                {/* Event Details */}
                <div style={{ marginTop: '48px', marginBottom: '48px' }}>
                    <div style={{ 
                        display: 'flex', 
                        alignItems: 'center', 
                        gap: '16px', 
                        marginBottom: '32px' 
                    }}>
                        <div style={{ flex: 1, height: '1px', background: styles.ink }} />
                        <p style={{ 
                            fontFamily: 'Inter, sans-serif', 
                            fontSize: '0.75rem', 
                            color: styles.inkSoft,
                            letterSpacing: '0.15em',
                            textTransform: 'uppercase'
                        }}>
                            EVENT DETAILS
                        </p>
                        <div style={{ flex: 1, height: '1px', background: styles.ink }} />
                    </div>
                    
                    <div style={{ display: 'flex', flexDirection: 'column', gap: '20px', alignItems: 'center' }}>
                        {rsvpedEvents.map(event => (
                            <div 
                                key={event.id} 
                                style={{ 
                                    border: `1px solid ${styles.fieldBorder}`,
                                    borderRadius: '4px',
                                    padding: '24px',
                                    maxWidth: '560px',
                                    width: '100%',
                                    textAlign: 'left'
                                }}
                            >
                                <h3 style={{ 
                                    fontFamily: "'Playfair Display', serif",
                                    fontSize: '1.25rem',
                                    color: styles.ink,
                                    marginBottom: '12px',
                                    letterSpacing: '0.05em'
                                }}>
                                    {event.nameOne && event.nameTwo 
                                        ? `${event.nameOne} ${event.andText || '&'} ${event.nameTwo}`
                                        : event.name
                                    }
                                </h3>
                                {event.venueName && (
                                    <p style={{ 
                                        fontFamily: 'Inter, sans-serif',
                                        fontSize: '0.875rem',
                                        color: styles.inkSoft,
                                        marginBottom: '8px'
                                    }}>
                                        {event.venueName}
                                    </p>
                                )}
                                {event.startAt && (
                                    <p style={{ 
                                        fontFamily: 'Inter, sans-serif',
                                        fontSize: '0.875rem',
                                        color: styles.inkSoft,
                                        marginBottom: '16px'
                                    }}>
                                        {new Date(event.startAt).toLocaleString('en-US', {
                                            weekday: 'long',
                                            year: 'numeric',
                                            month: 'long',
                                            day: 'numeric',
                                            hour: 'numeric',
                                            minute: '2-digit'
                                        })}
                                    </p>
                                )}

                                {/* Guest Details Section */}
                                {event.rsvp?.guestDetails && (event.rsvp.guestDetails.adults?.length > 0 || event.rsvp.guestDetails.children?.length > 0) && (
                                    <div style={{ 
                                        marginTop: '20px', 
                                        marginBottom: '20px',
                                        paddingTop: '20px',
                                        borderTop: `1px solid ${styles.fieldBorder}`
                                    }}>
                                        <p style={{ 
                                            fontFamily: 'Inter, sans-serif',
                                            fontSize: '0.75rem',
                                            color: styles.inkSoft,
                                            letterSpacing: '0.1em',
                                            textTransform: 'uppercase',
                                            marginBottom: '16px',
                                            fontWeight: '600'
                                        }}>
                                            Guest Details
                                        </p>
                                        
                                        {/* Adults */}
                                        {event.rsvp.guestDetails.adults?.length > 0 && (
                                            <div style={{ marginBottom: '16px' }}>
                                                {event.rsvp.guestDetails.adults.map((adult, idx) => (
                                                    <div key={idx} style={{ 
                                                        marginBottom: '12px',
                                                        paddingBottom: '12px',
                                                        borderBottom: idx < event.rsvp.guestDetails.adults.length - 1 ? `1px solid ${styles.fieldBorder}` : 'none'
                                                    }}>
                                                        <p style={{ 
                                                            fontFamily: 'Inter, sans-serif',
                                                            fontSize: '0.875rem',
                                                            color: styles.ink,
                                                            fontWeight: '600',
                                                            marginBottom: '4px'
                                                        }}>
                                                            {adult.name || `Adult ${idx + 1}`}
                                                        </p>
                                                        {adult.meal && (
                                                            <p style={{ 
                                                                fontFamily: 'Inter, sans-serif',
                                                                fontSize: '0.8125rem',
                                                                color: styles.inkSoft,
                                                                marginLeft: '20px',
                                                                marginBottom: '2px'
                                                            }}>
                                                                Meal: {event.mealOptions?.find(m => m.code === adult.meal)?.name || adult.meal}
                                                            </p>
                                                        )}
                                                        {adult.dietary && (
                                                            <p style={{ 
                                                                fontFamily: 'Inter, sans-serif',
                                                                fontSize: '0.8125rem',
                                                                color: styles.inkSoft,
                                                                marginLeft: '20px'
                                                            }}>
                                                                Dietary: {adult.dietary}
                                                            </p>
                                                        )}
                                                    </div>
                                                ))}
                                            </div>
                                        )}

                                        {/* Children */}
                                        {event.rsvp.guestDetails.children?.length > 0 && (
                                            <div>
                                                {event.rsvp.guestDetails.children.map((child, idx) => (
                                                    <div key={idx} style={{ 
                                                        marginBottom: '12px',
                                                        paddingBottom: '12px',
                                                        borderBottom: idx < event.rsvp.guestDetails.children.length - 1 ? `1px solid ${styles.fieldBorder}` : 'none'
                                                    }}>
                                                        <p style={{ 
                                                            fontFamily: 'Inter, sans-serif',
                                                            fontSize: '0.875rem',
                                                            color: styles.ink,
                                                            fontWeight: '600',
                                                            marginBottom: '4px'
                                                        }}>
                                                            {child.name || `Child ${idx + 1}`}
                                                        </p>
                                                        {child.meal && (
                                                            <p style={{ 
                                                                fontFamily: 'Inter, sans-serif',
                                                                fontSize: '0.8125rem',
                                                                color: styles.inkSoft,
                                                                marginLeft: '20px',
                                                                marginBottom: '2px'
                                                            }}>
                                                                Meal: {event.mealOptions?.find(m => m.code === child.meal)?.name || child.meal}
                                                            </p>
                                                        )}
                                                        {child.dietary && (
                                                            <p style={{ 
                                                                fontFamily: 'Inter, sans-serif',
                                                                fontSize: '0.8125rem',
                                                                color: styles.inkSoft,
                                                                marginLeft: '20px'
                                                            }}>
                                                                Dietary: {child.dietary}
                                                            </p>
                                                        )}
                                                    </div>
                                                ))}
                                            </div>
                                        )}
                                    </div>
                                )}
                                
                                <a 
                                    href={`/ics/event/${event.id}`}
                                    style={{
                                        display: 'inline-block',
                                        fontFamily: 'Inter, sans-serif',
                                        fontSize: '0.75rem',
                                        color: styles.bg,
                                        background: styles.accent,
                                        border: 'none',
                                        borderRadius: '9999px',
                                        padding: '10px 24px',
                                        letterSpacing: '0.1em',
                                        textTransform: 'uppercase',
                                        textDecoration: 'none',
                                        transition: 'background-color 150ms',
                                        fontWeight: '500'
                                    }}
                                    onMouseEnter={(e) => e.target.style.background = styles.accentHover}
                                    onMouseLeave={(e) => e.target.style.background = styles.accent}
                                >
                                    ADD TO CALENDAR
                                </a>
                            </div>
                        ))}
                    </div>
                </div>

                <p style={{ 
                    fontFamily: 'Inter, sans-serif', 
                    color: styles.inkSoft, 
                    fontSize: '0.95rem',
                    marginTop: '32px'
                }}>
                    Looking forward to celebrating with you!
                </p>
                <p style={{ 
                    fontFamily: "'Playfair Display', serif",
                    color: styles.ink,
                    fontSize: '1.125rem',
                    marginTop: '12px',
                    letterSpacing: '0.1em'
                }}>
                    {settings.coupleNames}
                </p>
            </div>
        </div>
    );
}
