import React from 'react';
import { Button } from '@/components/ui/button';

export default function SuccessView({ data }) {
    const { settings, events } = data;

    return (
        <div className="min-h-screen bg-background flex items-center justify-center px-4">
            <div className="max-w-2xl w-full bg-card rounded-lg shadow-lg p-8">
                <div className="text-center mb-6">
                    <div className="text-6xl mb-4">✓</div>
                    <h1 className="text-3xl font-bold mb-2">Thank You!</h1>
                    <p className="text-lg text-muted-foreground">
                        Your RSVP has been submitted successfully
                    </p>
                </div>

                <div className="border-t pt-6 space-y-4">
                    <h2 className="text-xl font-semibold mb-3">Event Details</h2>
                    
                    {events.map(event => (
                        <div key={event.id} className="bg-accent/50 rounded-lg p-4">
                            <h3 className="font-semibold mb-1">{event.name}</h3>
                            {event.venueName && (
                                <p className="text-sm text-muted-foreground">{event.venueName}</p>
                            )}
                            {event.startAt && (
                                <p className="text-sm text-muted-foreground mb-2">
                                    {new Date(event.startAt).toLocaleString('en-US', {
                                        weekday: 'long',
                                        year: 'numeric',
                                        month: 'long',
                                        day: 'numeric',
                                        hour: 'numeric',
                                        minute: '2-digit'
                                    })}
                                </p>
                            )}
                            
                            <a 
                                href={`/ics/event/${event.id}`}
                                className="inline-block mt-2"
                            >
                                <Button variant="outline" size="sm">
                                    Add to Calendar
                                </Button>
                            </a>
                        </div>
                    ))}
                </div>

                <div className="mt-6 text-center">
                    <p className="text-sm text-muted-foreground">
                        Looking forward to celebrating with you!
                    </p>
                    <p className="text-sm text-muted-foreground mt-2">
                        {settings.coupleNames}
                    </p>
                </div>

                <div className="mt-6 text-center">
                    <a href="/">
                        <Button variant="outline">Back to Home</Button>
                    </a>
                </div>
            </div>
        </div>
    );
}
