import React from 'react';

function CacheClear({ onNext, onBack }) {
  // Get the base URL and construct path to root clear-prod-cache.php
  // This works for both root installations and subdirectory installations
  const getClearCacheUrl = () => {
    const currentPath = window.location.pathname;
    // Remove /public/install or /install from the path to get base
    const basePath = currentPath.replace(/\/public\/install.*/, '').replace(/\/install.*/, '');
    return basePath + '/clear-prod-cache.php';
  };

  const handleComplete = () => {
    onNext();
  };

  return (
    <div className="card">
      <h2 className="text-2xl font-bold text-gray-900 mb-6">🎉 Installation Complete!</h2>
      <p className="text-gray-600 mb-6">
        Your application has been successfully configured. One final step remains: clearing the cache.
      </p>

      <div className="bg-orange-50 border border-orange-200 rounded-lg p-6 mb-6">
        <div className="flex items-start">
          <svg className="w-6 h-6 text-orange-600 mt-0.5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
          </svg>
          {/* <div className="flex-1">
            <h3 className="font-semibold text-orange-900 text-base mb-2">⚠️ Important: Clear Cache After Installation</h3>
            <p className="text-sm text-orange-800 mb-3">
              The cache cannot be cleared while the application is running in production mode. 
              You must clear it manually AFTER completing the installation.
            </p>
          </div> */}
        </div>
      </div>

      <div className="bg-gradient-to-r from-green-500 to-teal-500 rounded-lg p-8 text-center mb-6">
        <svg className="w-16 h-16 text-white mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
        </svg>
        <h3 className="text-white text-2xl font-bold mb-3">One Click to Finish!</h3>
        <p className="text-white text-sm mb-6 opacity-90">
          Visit the link below to automatically clear the cache and complete your installation
        </p>
        <a
          href={getClearCacheUrl()}
          target="_blank"
          rel="noopener noreferrer"
          className="inline-block bg-white text-green-600 font-bold text-lg px-8 py-4 rounded-lg shadow-lg hover:shadow-xl transform hover:scale-105 transition-all duration-200"
        >
          🚀 Clear Cache & Finish
        </a>
        <p className="text-white text-xs mt-4 opacity-75">
          Opens in new window • Script auto-deletes after use
        </p>
      </div>

      <div className="bg-blue-50 border border-blue-200 rounded-lg p-6 mb-6">
        <div className="flex items-start">
          <svg className="w-6 h-6 text-blue-600 mt-0.5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
          </svg>
          <div className="flex-1">
            <h3 className="font-semibold text-blue-900 text-base mb-2">How It Works</h3>
            <ol className="list-decimal list-inside space-y-2 text-sm text-blue-800">
              <li>Click the button above (opens in new window)</li>
              <li>The script clears your websites cache</li>
              <li>The script automatically deletes itself for security</li>
              <li>Return here and click "Complete Installation"</li>
            </ol>
          </div>
        </div>
      </div>
      
      <div className="bg-gray-50 border border-gray-200 rounded-lg p-4">
        <details className="cursor-pointer">
          <summary className="font-semibold text-gray-700 text-sm">Alternative: Manual Cache Clearing</summary>
          <div className="mt-3 space-y-2 text-xs text-gray-600">
            <p>If the automatic method doesn't work, manually delete the <code className="bg-gray-200 px-1 rounded">/var/cache/prod</code> folder using FTP or your file manager.</p>
          </div>
        </details>
      </div>

      <div className="flex justify-between pt-4">
        <button
          type="button"
          onClick={onBack}
          className="cursor-pointer btn btn-secondary"
        >
          Back
        </button>
        
        <button
          type="button"
          onClick={handleComplete}
          className="cursor-pointer btn btn-primary"
        >
          Complete Installation →
        </button>
      </div>
    </div>
  );
}

export default CacheClear;
