import React from 'react';

function App() {
    return (
        <div className="min-h-screen bg-gradient-to-br from-slate-900 via-slate-800 to-slate-900 flex items-center justify-center p-6">
            <div className="max-w-md w-full text-center">
                <div className="bg-white/10 backdrop-blur-sm rounded-lg p-8 shadow-2xl border border-white/20">
                    <h1 className="text-4xl font-bold text-white mb-4">
                        RSVP Manager
                    </h1>
                    <p className="text-slate-300 mb-8">
                        Wedding Event & Guest Management System
                    </p>
                    <a 
                        href="/admin" 
                        className="inline-block bg-white text-slate-900 font-semibold px-6 py-3 rounded-lg hover:bg-slate-100 transition-colors"
                    >
                        Go to Admin Panel
                    </a>
                </div>
            </div>
        </div>
    );
}

export default App;
