# ✅ Variable Placeholders Feature - Implementation Complete

## 🎯 What Was Added

You can now use **dynamic variable placeholders** in your email templates! The following variables are available:

- `{eventName}` - Name of the event (includes couple names)
- `{guestName}` - Guest's full name  
- `{eventDate}` - Formatted event date (e.g., "June 15, 2025")
- `{venueName}` - Venue location

## 📧 Where You Can Use Variables

### ✅ **Invitation Email** (Admin → Settings → Email Templates)
- **Subject Line** - e.g., "You're Invited to {eventName}!"
- **Message Content** - Full HTML message body

### ✅ **Reminder Email** (Admin → Settings → Email Templates)  
- **Subject Line** - e.g., "Reminder: {guestName}, please RSVP to {eventName}"
- **Message Content** - Full HTML message body

### ✅ **QR Ticket Email** (Admin → Settings → Email Templates)
- All customizable fields (Subject, Greeting, Intro, Message, etc.)

## 📝 Usage Examples

### Example 1: Personalized Invitation
```html
Subject: Join Us for {eventName}, {guestName}!

Message:
<p>Dear {guestName},</p>
<p>We would be <strong>honored</strong> to have you celebrate with us at {eventName}!</p>
<p>📅 <strong>Date:</strong> {eventDate}</p>
<p>📍 <strong>Venue:</strong> {venueName}</p>
<p>Please RSVP so we can finalize the arrangements.</p>
<p>With love,<br>John & Jane</p>
```

### Example 2: Formal Reminder
```html
Subject: RSVP Reminder - {eventName}

Message:
<p>Dear {guestName},</p>
<p>We noticed you haven't yet responded to our invitation for {eventName} on {eventDate}.</p>
<p>We would love to know if you can join us at {venueName}!</p>
<p>Best regards,<br>John & Jane</p>
```

### Example 3: Casual Invitation
```html
Subject: {guestName} - You're Invited! 🎉

Message:
<p>Hey {guestName}!</p>
<p>We're getting married and we want YOU there! 💒</p>
<p><strong>When:</strong> {eventDate}<br>
   <strong>Where:</strong> {venueName}</p>
<p>Can't wait to celebrate with you!</p>
<p>Love,<br>John & Jane ❤️</p>
```

## 🔧 Technical Changes Made

### 1. **EmailService.php** (`src/Service/EmailService.php`)
   - Added variable replacement function to `sendInviteEmail()`
   - Added `$venueName` parameter support
   - Variables are replaced before rendering the email template
   - Updated `sendBulkInvites()` to pass venue information

### 2. **Settings.js** (`assets/controllers/react/admin/pages/Settings.js`)
   - Updated UI descriptions to show available variables
   - Added variable hints to Invitation Email section
   - Added variable hints to Reminder Email section

### 3. **AdminApiController.php** (`src/Controller/Api/AdminApiController.php`)
   - Updated `/email/send-invite` endpoint to pass `venueName`

### 4. **Documentation**
   - Updated `EMAIL_CUSTOMIZATION_GUIDE.md` with variable examples
   - Added dedicated "Variable Placeholders" section
   - Updated Pro Tips to mention variables

## 🚀 How to Use

1. **Go to Admin Panel**
   - Navigate to: `Admin → Settings → Email Templates`

2. **Edit Invitation or Reminder Email**
   - You'll see the variable list in the description
   - Type variables directly in Subject or Message fields

3. **Example:**
   ```
   Subject: You're Invited to {eventName}!
   
   Message:
   <p>Dear {guestName},</p>
   <p>Join us on {eventDate} at {venueName}!</p>
   ```

4. **Save Settings**
   - Click "Save All Settings"
   - Variables will be automatically replaced when emails are sent

## ✨ Benefits

✅ **Personalization** - Each guest receives a customized email  
✅ **Efficiency** - Write one template, variables auto-populate  
✅ **Professional** - Consistent formatting with dynamic content  
✅ **Flexible** - Use all variables or just the ones you need  
✅ **HTML Compatible** - Combine with HTML tags for rich formatting

## 📌 Important Notes

- Variables are **case-sensitive** - use exact format: `{eventName}` not `{EventName}`
- If a variable value is not available (e.g., no venue name), it displays as empty string
- The `{eventDate}` format is automatically set to "Month Day, Year" (e.g., "June 15, 2025")
- You can use variables **anywhere** in Subject Lines and Message Content
- Variables work in **both plain text and HTML contexts**

## 🎨 Variable Sources

The variable values come from:

| Variable | Source |
|----------|--------|
| `{eventName}` | Provided when sending email (from event data, includes couple names) |
| `{guestName}` | Guest record name field |
| `{eventDate}` | Settings → Wedding Date field |
| `{venueName}` | Provided when sending email (from event/venue data) |

---

## ✅ Testing Recommendations

1. **Test with all variables:**
   ```
   <p>Hi {guestName}, join us for {eventName} on {eventDate} at {venueName}!</p>
   ```

2. **Send yourself a test email** before sending to all guests

3. **Check that all variables populate correctly**

4. **Verify HTML formatting displays properly**

---

**Your email system now supports full variable personalization! 🎉**
