# 🚀 Required Database Migrations

## Run These Commands Now:

```bash
# 1. Run all pending migrations (creates email template columns + guest detail columns)
php bin/console doctrine:migrations:migrate

# 2. Check migration status
php bin/console doctrine:migrations:status
```

---

## What These Migrations Do:

### Migration 1: Guest Details (Version20251029170500.php)
Adds columns to `guest` table:
- `type` - ADULT or CHILD
- `meal_choice` - Guest's meal selection
- `dietary_restrictions` - Dietary needs
- `attending` - Whether attending
- `notes` - Additional notes

### Migration 2: Email Templates (Version20251029184700.php)
Adds columns to `setting` table:
- `invite_email_subject` - Custom invite subject
- `invite_email_body` - Custom invite HTML
- `reminder_email_subject` - Custom reminder subject
- `reminder_email_body` - Custom reminder HTML

---

## After Running Migrations:

The admin should work perfectly! The `/api/settings` endpoint will auto-create default settings on first access.

---

## If You Get Errors:

**"Setting table doesn't exist":**
```bash
php bin/console doctrine:schema:update --force
```

**Migration already executed:**
That's fine! It means your database is up to date.
