# Public RSVP System

## ✅ What's New

You now have a **public RSVP system** where **anyone can access the RSVP page without tokens** and submit their information!

## 🎯 Public RSVP URL

```
http://127.0.0.1:8000/rsvp
```

**No token required!** Anyone can visit this URL and fill out the RSVP form.

## 🎨 Features

### For Guests:
- ✅ **Beautiful landing page** with couple names, wedding date, and location
- ✅ **Event details** - View all public events with venue, time, and description
- ✅ **Simple form** - Enter name, email, phone
- ✅ **Per-event RSVP** - Accept/decline for each event
- ✅ **Meal selection** - Choose meal preferences if enabled
- ✅ **Dietary restrictions** - Add allergies or dietary notes
- ✅ **Personal message** - Send well wishes to the couple
- ✅ **Success confirmation** - Thank you page after submission
- ✅ **Responsive design** - Works on mobile, tablet, and desktop

### What Gets Created:
When someone submits the public RSVP form:
1. **Household** is created/found by email
2. **Guest** record is created with their information
3. **RSVP** records created for each selected event
4. **Message** to couple is stored
5. All RSVPs appear in your **admin dashboard**!

## 📋 How It Works

### Backend Routes:
```php
GET  /rsvp                      → Public RSVP page (no token)
GET  /api/rsvp/public/events    → Get event list
POST /api/rsvp/public/submit    → Submit RSVP
```

### Token-Based Still Works:
The original token-based system still exists for pre-invited guests:
```
GET  /rsvp/{token}              → Private invite page
```

## 🔧 Setup Requirements

### 1. Create Events
Go to **Admin → Events** and create your events:
- Click "➕ Add Event"
- Fill in event details
- Toggle "Visible on RSVP page" ✓
- Enable meal selection if needed
- Save

### 2. Configure Settings
Go to **Admin → Settings** and set:
- **Couple Names** - e.g., "John & Jane"
- **Wedding Date** - Your wedding date
- **Location** - e.g., "Los Angeles, CA"
- **RSVP Deadline** (optional)

### 3. Share the Link
Share this URL with everyone:
```
http://127.0.0.1:8000/rsvp
```

Or add it to your:
- Wedding website navigation
- Email invitations
- Social media posts
- Wedding hashtag

## 📊 Managing RSVPs

All public RSVPs show up in your admin panel:

### **Admin → Guests**
- See all guests who RSVP'd
- View their contact info
- See household groupings

### **Admin → RSVPs**
- View all responses per event
- Filter by event, status
- Export for caterer/venue

### **Admin → Households**
- Grouped by email
- Copy invite links (for future)
- View tags and details

## 🎭 Customization

### Change Page Colors/Design
Edit: `assets/controllers/react/rsvp/PublicRsvpApp.js`

Current theme:
- Gradient: Pink to Purple background
- Primary: Pink buttons
- Beautiful card design

### Change Form Fields
Edit the `PublicRsvpApp.js` component to:
- Add/remove fields
- Change validation
- Modify layout

### Change Backend Logic
Edit: `src/Controller/InviteController.php`
- Method: `submitPublicRsvp()`

## 🔒 Security

- ✅ RSVP deadline check (optional)
- ✅ Email-based duplicate prevention
- ✅ CSRF protection on forms
- ✅ Input validation
- ✅ Public routes configured in `security.yaml`

## 📱 Mobile Responsive

The form automatically adapts to:
- 📱 Mobile phones (full-screen, stacked fields)
- 📲 Tablets (comfortable two-column layout)
- 💻 Desktops (wide, centered layout)

## 🚀 Next Steps

### Add to Your Website
Link to `/rsvp` from your wedding website:

```html
<a href="/rsvp">RSVP Now</a>
```

### Customize Welcome Text
Edit the React component to personalize:
- Header text
- Instructions
- Thank you message

### Add More Fields
Want to collect:
- Song requests?
- Dietary details?
- Plus-ones?
- Guest count?

Just add fields to the form and update the API!

## 🎉 Example Flow

1. **Guest visits** `http://127.0.0.1:8000/rsvp`
2. **Sees beautiful page** with wedding details
3. **Fills out form:**
   - Name: Sarah Smith
   - Email: sarah@example.com
   - Attending: ✓ Ceremony, ✓ Reception
   - Meal: Chicken
   - Message: "Can't wait!"
4. **Submits** → Success page
5. **You see it** in Admin → Guests & RSVPs

## 📞 Testing

1. **Open in browser:** `http://127.0.0.1:8000/rsvp`
2. **Fill out the form** with test data
3. **Submit**
4. **Check Admin panel** → Guests/RSVPs pages
5. **Verify** the guest appears!

## ⚙️ Configuration

All settings in **Admin → Settings**:
- Couple names
- Wedding date
- Location
- RSVP deadline
- (Events managed separately)

## 🎨 Want Different URL?

Current: `/rsvp`

To change to `/rsvp/{event-name}`:
1. Edit route in `InviteController.php`
2. Add event slug lookup
3. Filter events by slug

---

**🎊 Your public RSVP system is ready!** 

Visit: **http://127.0.0.1:8000/rsvp** to see it in action!
