# Per-Event Landing Pages

## ✅ What's New

Each event now has its **own unique landing page** with a custom URL!

## 🎯 How It Works

### URL Structure

When you create an event like **"Reception"**, it automatically gets a slug (URL-friendly version):

**Event Name** → **Slug** → **Landing Page URL**

- "Ceremony" → `ceremony` → `http://127.0.0.1:8000/rsvp/ceremony`
- "Reception" → `reception` → `http://127.0.0.1:8000/rsvp/reception`
- "Cocktail Hour" → `cocktail-hour` → `http://127.0.0.1:8000/rsvp/cocktail-hour`
- "Rehearsal Dinner" → `rehearsal-dinner` → `http://127.0.0.1:8000/rsvp/rehearsal-dinner`

### What Guests See

When someone visits `/rsvp/ceremony`, they see:
- ✅ **Only the Ceremony event** details
- ✅ Venue, time, description
- ✅ RSVP form specific to that event
- ✅ Meal selection (if enabled for that event)
- ✅ Your couple names and wedding info

**No other events shown** - it's a dedicated landing page!

## 📋 Using the View Button

### In Admin → Events:

Each event card now has a **"👁️ View Landing Page"** button that opens:

```
/rsvp/{that-event's-slug}
```

For example:
- **Reception event** → Opens `/rsvp/reception`
- **Ceremony event** → Opens `/rsvp/ceremony`

### Testing

1. Go to **Admin → Events**
2. Find your event (e.g., "Reception")
3. Click **"👁️ View Landing Page"**
4. New tab opens showing **only that event**'s RSVP page
5. Guests can fill out form and RSVP

## 🎨 Multiple URL Options

You now have **three ways** to share RSVP links:

### 1. All Events (Original)
```
http://127.0.0.1:8000/rsvp
```
Shows all your public events on one page

### 2. Single Event (New!)
```
http://127.0.0.1:8000/rsvp/ceremony
http://127.0.0.1:8000/rsvp/reception
```
Shows only that specific event

### 3. Token-Based (Original)
```
http://127.0.0.1:8000/rsvp/{unique-token}
```
Pre-invited guests with household tracking

## 🔧 Creating Events

When you create a new event:

1. Enter **Event Name**: "Rehearsal Dinner"
2. **Slug auto-generates**: `rehearsal-dinner`
3. **URL created**: `/rsvp/rehearsal-dinner`
4. Click **"👁️ View Landing Page"** to preview

### Custom Slugs

Want a different URL? You can manually set the slug in the future!

The slug is:
- Lowercase
- Spaces → hyphens
- Only letters, numbers, and hyphens
- Unique per event

## 📊 Example Use Cases

### Separate Invites

**Ceremony only:**
```
Share: /rsvp/ceremony
Only ceremony guests RSVP
```

**Reception only:**
```
Share: /rsvp/reception
Different guest list can RSVP
```

**Both:**
```
Share: /rsvp
Guests see and RSVP to both
```

### Wedding Weekend

- `/rsvp/welcome-drinks` - Thursday
- `/rsvp/ceremony` - Friday
- `/rsvp/reception` - Friday
- `/rsvp/brunch` - Saturday

Each has its own dedicated landing page!

## 🎯 Benefits

### For You:
- ✅ Separate RSVP tracking per event
- ✅ Different guest lists per event
- ✅ Easier to share specific events
- ✅ Professional, clean URLs
- ✅ One-click preview from admin

### For Guests:
- ✅ Clear, focused RSVP page
- ✅ No confusion with multiple events
- ✅ Easy-to-remember URLs
- ✅ Better mobile experience

## 📱 Sharing Links

### Email Invitations
```
"Please RSVP for our ceremony at:
https://yourwedding.com/rsvp/ceremony"
```

### Social Media
```
"Join us for our reception!
RSVP: yourwedding.com/rsvp/reception"
```

### Printed Cards
```
QR Code → /rsvp/ceremony
```

## 🔄 Existing Events

All existing events automatically got slugs:
- Check **Admin → Events** to see them
- Slug shown in the event details
- Click **View Landing Page** to test

## 💡 Pro Tips

1. **Keep names short** for cleaner URLs
   - "Ceremony" → `/rsvp/ceremony` ✓
   - "Wedding Ceremony at St. Mary's" → `/rsvp/wedding-ceremony-at-st-mary-s` ✗

2. **Toggle "Visible on RSVP page"**
   - Only shows public events
   - Hide private events

3. **Test before sharing**
   - Click **View Landing Page**
   - Check how it looks
   - Submit a test RSVP

4. **Track separately**
   - Admin → RSVPs
   - Filter by event
   - See who RSVP'd to what

## 🚀 Ready to Use!

1. ✅ Slug column added to database
2. ✅ Existing events have slugs
3. ✅ View buttons updated
4. ✅ Routes configured
5. ✅ React component updated
6. ✅ Assets built

**Test it now:**
- Go to **Admin → Events**
- Click **"👁️ View Landing Page"** on any event
- See your dedicated event RSVP page!

---

**Questions?**
- Want to customize slug? Edit event and change slug field
- Need all events on one page? Use `/rsvp` (no slug)
- Want token-based? Create household and use token URL
