# ✅ Email & Invites System - COMPLETE

## 🎉 What's Ready

Your email invitation system is fully implemented and ready to use!

### ✅ **Backend Complete:**
- SMTP fields added to `User` entity
- EmailService with send/test functionality
- API endpoints for sending emails
- Beautiful HTML email template
- Database migration completed

### ✅ **Frontend Complete:**
- New **"📧 Invites"** menu in admin sidebar
- Full Invites page with UI
- Select events and recipients
- Test SMTP connection
- Bulk send functionality
- Assets built and ready

### ✅ **Database Complete:**
- 7 SMTP columns added to `user` table:
  - `smtp_host`
  - `smtp_port`
  - `smtp_username`
  - `smtp_password`
  - `smtp_encryption`
  - `smtp_from_email`
  - `smtp_from_name`

---

## 🚀 How to Use

### 1. Configure SMTP Settings

You need to add SMTP settings to your user account in the database:

```sql
UPDATE `user` SET 
    smtp_host = 'smtp.gmail.com',
    smtp_port = 587,
    smtp_username = 'your-email@gmail.com',
    smtp_password = 'your-app-password',
    smtp_encryption = 'tls',
    smtp_from_email = 'your-email@gmail.com',
    smtp_from_name = 'Wedding Invitations'
WHERE id = 1;
```

### 2. Access the Invites Page

1. **Refresh your admin panel** (Ctrl + F5)
2. Look in the sidebar for **"📧 Invites"**
3. Click to open the Invites page

### 3. Test SMTP Connection

1. On the Invites page, click **"🔌 Test SMTP Connection"**
2. You should see: ✓ SMTP connection successful!
3. If it fails, check your SMTP credentials

### 4. Send Invitations

**To send invites:**
1. **Select Event** (optional) - Choose a specific event or leave blank for general invitation
2. **Search/Select Recipients** - Check households you want to invite
3. Click **"✉️ Send to X Recipients"**
4. Wait for confirmation

---

## 📧 SMTP Provider Setup

### Gmail (Recommended for Testing)

**Settings:**
```
Host: smtp.gmail.com
Port: 587
Username: your-email@gmail.com
Password: [App Password - NOT your regular password!]
Encryption: tls
```

**How to get App Password:**
1. Go to: https://myaccount.google.com/apppasswords
2. Select "Mail" and "Other"
3. Name it "Wedding RSVP"
4. Copy the 16-character password
5. Use this as your SMTP password

### Mailtrap (Free Testing)

Perfect for testing without sending real emails!

```
Host: sandbox.smtp.mailtrap.io
Port: 2525
Username: (from Mailtrap)
Password: (from Mailtrap)
Encryption: tls
```

Sign up: https://mailtrap.io

### SendGrid (Production)

For production use with high volume:

```
Host: smtp.sendgrid.net
Port: 587
Username: apikey
Password: [Your SendGrid API key]
Encryption: tls
```

---

## 📨 What Guests Receive

When you send an invite, guests get a beautiful HTML email with:

**Content:**
- 💒 Pink gradient header
- Couple names (from Settings)
- Personal greeting with their name
- Event details
- Wedding date
- Big **"RSVP Now"** button
- Direct link to their RSVP page

**Example:**
```
Dear Smith Family,

We are delighted to invite you to our Reception!

Date: June 15, 2025

[RSVP Now] (Button)

We can't wait to celebrate with you!

With love,
John & Jane
```

**The RSVP link goes to:**
- `/rsvp/reception` (if you selected an event)
- `/rsvp` (if no event selected)

---

## 🎯 Features

### Event-Specific or General
- **Select an event**: Sends invite for that specific event
- **Leave blank**: Sends general wedding invitation

### Smart Recipient Selection
- ✅ Shows only households with email addresses
- ✅ Search by name or email
- ✅ Select all or individual
- ✅ Shows tags for easy filtering
- ✅ Indicates if already invited

### Bulk Sending
- Send to multiple households at once
- Shows progress: "✓ Sent: X, ❌ Failed: X"
- Continues even if some fail
- Error details in console

### Statistics
- Total households
- Households with email
- Currently selected count

---

## 🔧 API Endpoints

Three new endpoints available:

### Test SMTP
```
POST /api/email/test-smtp
```
Tests connection with current user's SMTP settings.

### Send Single Invite
```
POST /api/email/send-invite

Body:
{
  "email": "guest@example.com",
  "name": "Guest Name",
  "eventSlug": "ceremony",
  "eventName": "Ceremony"
}
```

### Send Bulk Invites
```
POST /api/email/send-bulk

Body:
{
  "recipients": [
    {"email": "...", "name": "...", "eventName": "...", "eventSlug": "..."}
  ],
  "eventSlug": "reception"
}

Response:
{
  "sent": 5,
  "failed": 0,
  "errors": []
}
```

---

## 🔐 Security

- ✅ Only authenticated users can send emails
- ✅ SMTP settings per user account
- ✅ Role-based access (ROLE_ADMIN required)
- ⚠️ SMTP passwords stored in database (consider encryption for production)

---

## 🐛 Troubleshooting

### "SMTP connection failed"

**Check:**
- Host and port are correct
- Username matches from_email
- Using App Password (not regular password for Gmail)
- Try port 465 with SSL instead of 587/TLS
- Check firewall isn't blocking port

### "Failed to send email"

**Check:**
- from_email matches SMTP username
- Recipient email is valid
- Not hitting rate limits
- Check spam folder

### Emails not showing up

**Check:**
- Spam/junk folder
- Email provider logs
- Try Mailtrap to verify emails are sending

### "SMTP not configured" warning

**Solution:**
- Add SMTP settings to your user account in database
- Test connection to verify

---

## 📊 Next Steps

### Recommended:
1. ✅ Test with Mailtrap first
2. ✅ Send test invite to yourself
3. ✅ Verify email looks good
4. ✅ Test RSVP link works
5. ✅ Switch to real SMTP provider
6. ✅ Send real invites!

### Optional Enhancements:
- Add SMTP settings UI in Settings page
- Email open tracking
- Click tracking
- Resend functionality
- Email history log
- Schedule sending
- Email templates

---

## 📂 Files Created/Modified

### Created:
- `src/Service/EmailService.php` - Email sending service
- `src/Controller/Api/AdminApiController.php` - Added email endpoints
- `assets/controllers/react/admin/pages/Invites.js` - Invites page UI
- `EMAIL_SYSTEM_COMPLETE.md` - This guide

### Modified:
- `src/Entity/User.php` - Added SMTP fields
- `assets/controllers/react/admin/App.js` - Added Invites menu/route
- Database `user` table - Added 7 SMTP columns

---

## ✨ Success!

Your wedding RSVP system now has:
- ✅ Per-event landing pages (`/rsvp/ceremony`, `/rsvp/reception`)
- ✅ Email invitation system
- ✅ Beautiful HTML email templates
- ✅ SMTP configuration per user
- ✅ Bulk sending capability
- ✅ Admin interface to manage invites

**Ready to invite your guests! 🎉**

---

**Questions or Issues?**
- Check SMTP credentials
- Test with Mailtrap first
- Verify RSVP links work
- Check spam folders
- Review error logs in browser console
