# 📧 Email Customization Guide

## ✅ What Admins CAN Edit (Admin Settings → Email Templates)

### **For Both Invite & Reminder Emails:**

#### **1. Subject Lines**
- **Invite Default:** "You're Invited to Our Wedding!"
- **Reminder Default:** "Reminder: Please RSVP to Our Wedding"
- ✅ Fully customizable

#### **2. Message Content**
- **Invite Default:** "We are delighted to invite you to our wedding!"
- **Reminder Default:** "We noticed you haven't responded..."
- ✅ Supports HTML tags: `<p>`, `<strong>`, `<em>`, `<ul>`, `<li>`, etc.
- ✅ Supports variable placeholders: `{eventName}`, `{guestName}`, `{eventDate}`, `{venueName}`
- ✅ Inserted into template at `{{ message|raw }}`

#### **3. Button Text**
- **Default:** "RSVP Now"
- ✅ Can change to: "Confirm Attendance", "Respond Now", etc.

#### **4. Button Color**
- **Default:** `#c2185b` (Pink/Burgundy)
- ✅ Color picker + hex input
- ✅ Changes button AND title color

#### **5. Call to Action Text**
- **Default:** "Please RSVP by clicking the button below:"
- ✅ Can change to: "Kindly respond using the button below:", etc.

#### **6. Closing Text**
- **Default:** "We can't wait to celebrate with you!"
- ✅ Can change to: "Looking forward to celebrating together!", etc.

#### **7. Custom Signature (Optional)**
- **Default:** "With love, [Couple Names]"
- ✅ Override with custom HTML
- ✅ Leave blank to use default

---

## ❌ What Admins CANNOT Edit (Fixed in Twig Templates)

These elements are hardcoded in `templates/emails/*.twig`:

1. **Email Structure:**
   - Greeting: "Dear {{ guestName }},"
   - Date label: "Date:"
   - Link text: "Or copy this link:"
   - Footer: "This is an automated invitation email."

2. **Design & Styling:**
   - Font family (Arial, sans-serif)
   - Container width (600px)
   - Header gradient background
   - Border radius, shadows
   - Padding, spacing

3. **Layout:**
   - Header position
   - Content ordering
   - Footer placement

---

## 📊 Complete Customization Matrix

| Element | Location | Editable? | Default Value |
|---------|----------|-----------|---------------|
| **Subject Line (Invite)** | Database | ✅ Yes | "You're Invited to Our Wedding!" |
| **Subject Line (Reminder)** | Database | ✅ Yes | "Reminder: Please RSVP to Our Wedding" |
| **Message Content (Invite)** | Database | ✅ Yes | "We are delighted..." |
| **Message Content (Reminder)** | Database | ✅ Yes | "We noticed you haven't..." |
| **Button Text** | Database | ✅ Yes | "RSVP Now" |
| **Button Color** | Database | ✅ Yes | `#c2185b` |
| **Call to Action** | Database | ✅ Yes | "Please RSVP by clicking..." |
| **Closing Text** | Database | ✅ Yes | "We can't wait to celebrate..." |
| **Signature** | Database | ✅ Yes | "With love, [Couple Names]" |
| **Greeting** | Template | ❌ No | "Dear {{ guestName }}," |
| **Date Label** | Template | ❌ No | "Date:" |
| **Link Text** | Template | ❌ No | "Or copy this link:" |
| **Footer** | Template | ❌ No | "This is an automated invitation email." |
| **Fonts** | Template | ❌ No | Arial, sans-serif |
| **Layout** | Template | ❌ No | Fixed structure |
| **Container Width** | Template | ❌ No | 600px |
| **Header Gradient** | Template | ❌ No | #fce4ec → #f3e5f5 |

---

## 🔤 Variable Placeholders

All invitation and reminder email fields (Subject Line, Message Content) support dynamic variable replacement:

| Variable | Description | Example Value |
|----------|-------------|---------------|
| `{eventName}` | Name of the event | "John & Jane's Wedding" |
| `{guestName}` | Guest's full name | "Sarah Williams" |
| `{eventDate}` | Formatted event date | "June 15, 2025" |
| `{venueName}` | Venue location | "Grand Hotel Ballroom" |

**Usage Example:**
```html
<p>Dear {guestName},</p>
<p>You're invited to {eventName} on {eventDate} at {venueName}!</p>
```

**Renders as:**
```
Dear Sarah Williams,
You're invited to John & Jane's Wedding on June 15, 2025 at Grand Hotel Ballroom!
```

---

## 🎨 Example: Complete Customization

**Admin Settings:**
```
Subject: Join Us for Our Special Day!
Message: <p>Dear {guestName},</p>
         <p>We would be <strong>honored</strong> to have you celebrate with us at {eventName}!</p>
         <p>The celebration will take place on {eventDate} at {venueName}.</p>
Button Text: Confirm Attendance
Button Color: #4a148c (Purple)
Call to Action: Please let us know if you can join us:
Closing: We hope to see you there!
Signature: <p><em>Much love,</em><br>John & Jane Smith</p>
```

**Result Email:**
```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
💒 Join Us for Our Special Day! 💒
John & Jane Smith
━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Dear Sarah Williams,

We would be honored to have you celebrate with us!

Date: June 15, 2025

Please let us know if you can join us:

┌─────────────────────┐
│  Confirm Attendance │  ← Purple button
└─────────────────────┘

Or copy this link:
https://example.com/rsvp/abc123

We hope to see you there!

Much love,
John & Jane Smith
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
This is an automated invitation email.
```

---

## 🚀 Setup Instructions

1. **Run SQL Migration:**
   ```bash
   mysql -u root -p wed_rsvp < add_email_customization.sql
   ```

2. **Access Settings:**
   - Go to: `Admin → Settings → ✉️ Email Templates`
   - Scroll to: "Email Customization" card

3. **Customize:**
   - Edit any fields
   - Click "Save Settings"
   - Send test email to verify

---

## 💡 Pro Tips

✅ **Use variable placeholders** - Personalize with `{guestName}`, `{eventName}`, `{eventDate}`, `{venueName}`  
✅ **Use color picker** for button color - instant visual feedback  
✅ **HTML in messages** - Bold, italic, lists supported  
✅ **Custom signature** - Add family names, emojis, or special formatting  
✅ **Test emails** - Send to yourself before bulk sending  
✅ **Consistent branding** - Use your wedding colors for button  

---

## 🎯 Common Use Cases

**Formal Wedding:**
```
Button Color: #1a237e (Navy)
Button Text: "Respond to Invitation"
Closing: "We look forward to celebrating this special day with you."
```

**Casual Wedding:**
```
Button Color: #ff6f00 (Orange)
Button Text: "Let Us Know!"
Closing: "Can't wait to party with you! 🎉"
```

**Destination Wedding:**
```
Call to Action: "Please confirm your attendance so we can arrange accommodations:"
Closing: "We're excited to celebrate with you in paradise!"
```

---

Your email system is now fully customizable! 🎉
