# Demo Data Setup Instructions

This guide explains how to populate your RSVP application with realistic demo data for testing and demonstrations.

## Method 1: Using Doctrine Fixtures (Recommended)

### Prerequisites
Install the Doctrine Fixtures Bundle if not already installed:
```bash
composer require --dev doctrine/doctrine-fixtures-bundle
```

### Load Demo Data
Run the following command to load all demo data:
```bash
php bin/console doctrine:fixtures:load
```

**⚠️ WARNING:** This will **purge your database** and remove all existing data!

To append data without purging:
```bash
php bin/console doctrine:fixtures:load --append
```

### What Gets Created
- **2 Events:**
  - Wedding Ceremony (with meal options)
  - Reception & Dinner (with meal options)
  
- **10 Households** with varying data:
  - Different sides (Bride/Groom)
  - Complete contact information
  - Mixed RSVP statuses
  
- **25 Guests:**
  - Adults and children
  - Meal preferences
  - Dietary restrictions
  
- **Admin User:**
  - Email: `admin@example.com`
  - Password: `admin123`

### Demo Data Scenarios
The fixtures create realistic scenarios:
- ✅ **Confirmed Attendees** (6 households) - with meal choices
- ❌ **Declined** (1 household)
- ❓ **Maybe** (1 household)
- ⏳ **Not Yet Responded** (2 households)

## Method 2: SQL Import (Alternative)

If you prefer SQL, you can use the `demo_data.sql` file (see below).

### Import SQL File
```bash
# MySQL/MariaDB
mysql -u your_username -p your_database < demo_data.sql

# Or via PHP
php bin/console doctrine:query:sql "$(cat demo_data.sql)"
```

## Resetting Demo Data

To reset and reload demo data:
```bash
# Drop and recreate database
php bin/console doctrine:database:drop --force
php bin/console doctrine:database:create
php bin/console doctrine:migrations:migrate --no-interaction

# Load fixtures
php bin/console doctrine:fixtures:load --no-interaction
```

## Customizing Demo Data

Edit `src/DataFixtures/AppFixtures.php` to customize:
- Number of households
- Guest names
- Event details
- RSVP statuses
- Meal preferences

## Testing RSVP Forms

After loading fixtures, you can test the public RSVP form using household tokens:
- Each household has a unique token in the database
- Check the `household` table's `token` column
- Access form: `/rsvp/invite/{token}`

## Useful Commands

```bash
# View all households with tokens
php bin/console doctrine:query:sql "SELECT id, display_name, email, token FROM household"

# View RSVP statistics
php bin/console doctrine:query:sql "SELECT status, COUNT(*) as count FROM household_event_rsvp GROUP BY status"

# Clear all data (keep structure)
php bin/console doctrine:query:sql "SET FOREIGN_KEY_CHECKS=0; TRUNCATE household_event_rsvp; TRUNCATE guest; TRUNCATE household; TRUNCATE event; SET FOREIGN_KEY_CHECKS=1;"
```

## Production Warning

🚨 **NEVER run fixtures on a production database!** This will delete all real data.

Always use fixtures only in development/staging environments.
