# Bulk QR Ticket Sending - Complete ✅

## Feature Overview

Admins can now send QR code tickets via email to multiple confirmed guests at once!

**Complete Workflow:**
```
Guest RSVPs → Admin views RSVPs page → Selects confirmed guests → Send QR Tickets → Guests receive email → Show QR at venue ✅
```

---

## How to Use

**1. Navigate to RSVPs Page** ⭐ NEW LOCATION
- Admin Panel → RSVPs
- Event is automatically selected

**2. Select Confirmed Guests**
- Check boxes next to households who RSVPed "Yes" (green badge)
- Selection count appears: "12 households selected"

**3. Click "Send QR Tickets"**
- Button appears: [Send QR Tickets (12)]
- Only available in HOUSEHOLD mode

**4. Review Recipients**
- Modal opens showing selected households
- Event is already chosen (current event)
- Review: Name, Email, Adults, Children

**5. Send!**
- Click [Send Tickets]
- Toast: "Successfully sent 12 QR tickets!"

---

## Email Template

Guests receive:
- 🎫 Subject: "Your QR Code Ticket for [Event]"
- Event details (date, venue)
- [View My Ticket] button
- Direct ticket URL
- Instructions on how to use
- Bookmark/screenshot tips

---

## Technical Implementation

### Backend Files

**`src/Service/EmailService.php`**
- Added `sendTicketEmail()`
- Added `sendBulkTickets()`

**`src/Controller/Api/AdminApiController.php`**
- Added `POST /api/email/send-tickets`

**`templates/emails/ticket-email.html.twig`**
- Beautiful HTML email template

### Frontend Files

**`assets/controllers/react/admin/pages/RSVPs.js`** ⭐ PRIMARY LOCATION
- Added "Send QR Tickets" button (HOUSEHOLD mode only)
- Added checkboxes for selecting confirmed RSVPs
- Added bulk send modal
- API integration with `/api/email/send-tickets`
- Event auto-selected from current view

**`assets/controllers/react/admin/pages/Households.js`**
- QR ticket sending removed (moved to RSVPs)
- Still has "Send Invites" and "Send Reminders"

---

## API Reference

**POST** `/api/email/send-tickets`

```json
{
    "eventId": 2,
    "recipients": [
        {"id": 5, "email": "smith@example.com", "name": "Smith Family"}
    ]
}
```

Response:
```json
{"sent": 1, "failed": 0, "errors": []}
```

---

## Requirements

**SMTP Setup Required:**
- Settings → User Profile → SMTP Settings
- Configure: Host, Port, Username, Password
- Test connection before sending

**Recommended Providers:**
- Gmail (500/day free)
- SendGrid (100/day free)
- Mailgun (5000/month free)

---

## Testing

**Quick Test:**
1. Add test household with your email
2. Mark as confirmed
3. Send QR ticket
4. Verify email received
5. Open ticket link
6. Test scanner at `/checkin`

---

## Benefits

**For Admins:**
- ✅ Select all confirmed guests at once
- ✅ One click to send all tickets
- ✅ Professional email template
- ✅ Track success/failures
- ✅ Save hours of work

**For Guests:**
- ✅ Clear instructions
- ✅ Beautiful design
- ✅ Easy mobile access
- ✅ Can't lose digital ticket

---

## Status

✅ **Production Ready**
- Backend: Complete
- Frontend: Complete
- Email template: Complete
- Documentation: Complete
- Build: Compiled successfully

**Ready to send bulk QR tickets!** 🎉
